/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.chililisoup.condiments.block.CrateBlock;
import dev.chililisoup.condiments.block.entity.CrateBlockEntity;
import dev.chililisoup.condiments.config.CommonConfig;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class CrateRenderer
implements BlockEntityRenderer<CrateBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final Font font;

    public CrateRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
        this.font = context.getFont();
    }

    public int getViewDistance() {
        return 32;
    }

    public void render(CrateBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        Entity player = Minecraft.getInstance().getCameraEntity();
        if (player == null) {
            return;
        }
        ItemStack item = blockEntity.getItemType();
        if (item.isEmpty()) {
            return;
        }
        FrontAndTop fat = (FrontAndTop)blockEntity.getBlockState().getValue((Property)BlockStateProperties.ORIENTATION);
        Vec3i norm = fat.front().getNormal();
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockEntity.getBlockPos().relative(fat.front(), 1));
        this.renderText(item, blockEntity, poseStack, buffer, fat, norm, light);
        CrateRenderer.renderItem(level, item, poseStack, buffer, light, packedOverlay, fat, norm, this.itemRenderer);
    }

    private void renderText(ItemStack item, CrateBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, FrontAndTop fat, Vec3i norm, int light) {
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        if (hitResult2.getType() == HitResult.Type.MISS) {
            return;
        }
        if (!hitResult2.getBlockPos().equals((Object)blockEntity.getBlockPos())) {
            return;
        }
        if (hitResult2.getDirection() != fat.front()) {
            return;
        }
        Optional<Vec2> hitPos = CrateBlock.getHitPosition(hitResult2, fat.front());
        if (hitPos.isEmpty()) {
            return;
        }
        if (CrateBlock.isNotInBounds(hitPos.get())) {
            return;
        }
        String text = String.format("%d / %d", blockEntity.getCount(), item.getMaxStackSize() * CommonConfig.CRATE_MAX_CONTAINED_STACKS.get());
        poseStack.pushPose();
        poseStack.translate((double)norm.getX() / 2.0 + 0.5, (double)norm.getY() / 2.0 + 0.5, (double)norm.getZ() / 2.0 + 0.5);
        poseStack.mulPose(fat.front().getRotation());
        poseStack.mulPose(Direction.NORTH.getRotation());
        if (fat.front().getAxis() == Direction.Axis.Y) {
            int dir = fat.front().getAxisDirection().getStep();
            int rot = (dir + 1) * 90;
            poseStack.mulPose(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, (float)dir, fat.top().toYRot() + (float)rot));
        }
        poseStack.scale(-0.01f, -0.01f, -0.01f);
        this.font.drawInBatch(text, (float)(-this.font.width(text) / 2), -48.0f, 0xFFFFFF, true, poseStack.last().pose(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, light);
        poseStack.popPose();
    }

    public static void renderItem(@Nullable Level level, ItemStack item, PoseStack poseStack, MultiBufferSource buffer, int light, int packedOverlay, FrontAndTop fat, Vec3i norm, ItemRenderer itemRenderer) {
        boolean is3d = itemRenderer.getModel(item, level, null, 0).isGui3d();
        double offset = is3d ? 2.3 : 2.6;
        poseStack.pushPose();
        poseStack.translate((double)norm.getX() / offset + 0.5, (double)norm.getY() / offset + 0.5, (double)norm.getZ() / offset + 0.5);
        poseStack.mulPose(fat.front().getOpposite().getRotation());
        poseStack.mulPose(Direction.NORTH.getRotation());
        if (fat.front().getAxis() == Direction.Axis.Y) {
            int dir = fat.front().getAxisDirection().getStep();
            int rot = (dir + 1) * 90;
            poseStack.rotateAround(new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), 0.0f, 0.0f, 0.0f);
            poseStack.mulPose(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, (float)(-dir), fat.top().toYRot() + (float)rot));
        }
        if (is3d) {
            poseStack.last().pose().scale(0.7f, 0.7f, 0.005f);
        } else {
            poseStack.scale(0.6f, 0.6f, 0.6f);
        }
        itemRenderer.renderStatic(item, ItemDisplayContext.GUI, light, packedOverlay, poseStack, buffer, level, 0);
        poseStack.popPose();
    }
}

