/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.item.crafting;

import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.item.CrateItem;
import dev.chililisoup.condiments.reg.ModComponents;
import dev.chililisoup.condiments.reg.ModRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrateLocking
extends CustomRecipe {
    public CrateLocking(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < input.size(); ++k) {
            ItemStack itemStack = input.getItem(k);
            if (itemStack.isEmpty()) continue;
            if (itemStack.getItem() instanceof CrateItem) {
                ++i;
            } else {
                if (!itemStack.is(Items.REDSTONE_TORCH)) {
                    return false;
                }
                ++j;
            }
            if (j <= 1 && i <= 1) continue;
            return false;
        }
        return i == 1 && j == 1;
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack itemStack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemStack2 = input.getItem(i);
            if (itemStack2.isEmpty() || !(itemStack2.getItem() instanceof CrateItem)) continue;
            itemStack = itemStack2.copyWithCount(1);
            break;
        }
        CrateContents crateContents = (CrateContents)itemStack.getOrDefault(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY);
        CrateContents.Mutable mutable = crateContents.toMutable();
        mutable.setLocked(true);
        itemStack.set(ModComponents.CRATE_CONTENTS.get(), (Object)mutable.toImmutable());
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.CRATE_LOCKING.get();
    }
}

