/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.item.crafting;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.block.CrateBlock;
import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.reg.ModBlocks;
import dev.chililisoup.condiments.reg.ModComponents;
import dev.chililisoup.condiments.reg.ModItemTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class ModRecipeDisplays {
    public static List<RecipeHolder<CraftingRecipe>> getAll() {
        ArrayList<RecipeHolder<CraftingRecipe>> combined = new ArrayList<RecipeHolder<CraftingRecipe>>();
        combined.addAll(ModRecipeDisplays.crateColoringRecipe());
        combined.addAll(ModRecipeDisplays.crateLockingRecipe());
        combined.addAll(ModRecipeDisplays.crateUnlockingRecipe());
        return combined;
    }

    public static List<RecipeHolder<CraftingRecipe>> crateColoringRecipe() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipeList = new ArrayList<RecipeHolder<CraftingRecipe>>();
        String group = "crate_coloring";
        Ingredient ingredients = Ingredient.of(ModItemTags.CRATES);
        for (DyeColor color : DyeColor.values()) {
            DyeItem dye = DyeItem.byColor((DyeColor)color);
            ItemStack output = CrateBlock.getColoredItemStack(color);
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ingredients, Ingredient.of((ItemLike[])new ItemLike[]{dye})});
            ResourceLocation loc = Condiments.loc("/crate_coloring_" + color.getName());
            recipeList.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(loc, (Recipe)new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs)));
        }
        return recipeList;
    }

    public static List<RecipeHolder<CraftingRecipe>> crateLockingRecipe() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipeList = new ArrayList<RecipeHolder<CraftingRecipe>>();
        String group = "crate_locking";
        Ingredient ingredients = Ingredient.of(ModItemTags.CRATES);
        for (ItemStack input : ingredients.getItems()) {
            ItemStack output = input.copy();
            output.set(ModComponents.CRATE_CONTENTS.get(), (Object)new CrateContents(Optional.empty(), 0, Optional.of(true)));
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{input}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE_TORCH})});
            ResourceLocation loc = Condiments.loc("/crate_coloring_crate_locking_" + input.getDescriptionId());
            recipeList.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(loc, (Recipe)new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs)));
        }
        return recipeList;
    }

    public static List<RecipeHolder<CraftingRecipe>> crateUnlockingRecipe() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipeList = new ArrayList<RecipeHolder<CraftingRecipe>>();
        String group = "crate_locking";
        Ingredient ingredients = Ingredient.of(ModItemTags.CRATES);
        for (ItemStack output : ingredients.getItems()) {
            ItemStack input = output.copy();
            input.set(ModComponents.CRATE_CONTENTS.get(), (Object)new CrateContents(Optional.empty(), 0, Optional.of(true)));
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{input}), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})});
            ResourceLocation loc = Condiments.loc("/crate_unlocking_" + input.getDescriptionId());
            recipeList.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(loc, (Recipe)new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs)));
        }
        return recipeList;
    }

    public static Map<ItemLike, Component> ingredientInfos() {
        return Map.of((ItemLike)ModBlocks.BLACKENED_IRON_BLOCK.get(), Component.translatable((String)"condiments.ingredient_info.blackened_iron_block"));
    }
}

