/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.item.tooltip;

import dev.chililisoup.condiments.item.tooltip.CrateTooltip;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientCrateTooltip
implements ClientTooltipComponent {
    private final ItemStack item;

    public ClientCrateTooltip(CrateTooltip crateTooltip) {
        this.item = crateTooltip.item();
    }

    public int getHeight() {
        if (this.item.is(Items.AIR)) {
            return 0;
        }
        return 16;
    }

    public int getWidth(Font font) {
        if (this.item.is(Items.AIR)) {
            return 0;
        }
        return 18 + font.width((FormattedText)this.item.getHoverName());
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (this.item.is(Items.AIR)) {
            return;
        }
        guiGraphics.renderItem(this.item, x, y - 2);
        guiGraphics.renderItemDecorations(font, this.item, x, y - 2);
        guiGraphics.drawString(font, this.item.getHoverName(), x + 18, y + 2, 0xFFFFFF, true);
    }
}

