/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import dev.chililisoup.condiments.config.CommonConfig;
import dev.chililisoup.condiments.inject.BeaconBlockEntityInject;
import dev.chililisoup.condiments.reg.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BeaconBlockEntity.class})
public abstract class BeaconBlockEntityMixin
implements BeaconBlockEntityInject {
    @Unique
    private int condiments$topY;

    @Override
    public int condiments$getTopY() {
        return this.condiments$topY;
    }

    @Override
    public void condiments$setTopY(int topY) {
        this.condiments$topY = topY;
    }

    @WrapOperation(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getHeight(Lnet/minecraft/world/level/levelgen/Heightmap$Types;II)I")})
    private static int updateTopY(Level level, Heightmap.Types heightmapType, int x, int z, Operation<Integer> original, @Local(argsOnly=true) BeaconBlockEntity blockEntity) {
        blockEntity.condiments$setTopY(level.getHeight());
        return (Integer)original.call(new Object[]{level, heightmapType, x, z});
    }

    @ModifyExpressionValue(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z")})
    private static boolean allowTintedGlass(boolean original, @Local(argsOnly=true) BeaconBlockEntity blockEntity, @Local(ordinal=1) BlockState blockState, @Local(ordinal=1) BlockPos blockPos, @Local(ordinal=3) LocalIntRef levelHeight) {
        if (original) {
            return true;
        }
        if (!blockState.is(ModBlockTags.TINTED_GLASS)) {
            return false;
        }
        if (!CommonConfig.TINTED_GLASS_TERMINATES_BEACONS.get().booleanValue()) {
            return false;
        }
        int topY = blockPos.getY() - 1;
        blockEntity.condiments$setTopY(topY);
        levelHeight.set(topY);
        return true;
    }

    @WrapOperation(method={"applyEffects(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ILnet/minecraft/core/Holder;Lnet/minecraft/core/Holder;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getHeight()I")})
    private static int adjustEffectRange(Level level, Operation<Integer> original, @Local(argsOnly=true) BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BeaconBlockEntity) {
            BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
            return beaconBlockEntity.condiments$getTopY();
        }
        return (Integer)original.call(new Object[]{level});
    }
}

