/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.reg;

import dev.chililisoup.condiments.block.AnalogRailBlock;
import dev.chililisoup.condiments.block.RedstoneLedBlock;
import dev.chililisoup.condiments.client.renderer.CrateItemRenderer;
import dev.chililisoup.condiments.client.renderer.CrateRenderer;
import dev.chililisoup.condiments.item.tooltip.ClientCrateTooltip;
import dev.chililisoup.condiments.item.tooltip.CrateTooltip;
import dev.chililisoup.condiments.reg.ModBlockEntities;
import dev.chililisoup.condiments.reg.ModBlocks;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientRegistry {
    public static void init() {
        ClientHelper.addClientSetup(ClientRegistry::setup);
        ClientHelper.addBlockEntityRenderersRegistration(ClientRegistry::registerBlockEntityRenderers);
        ClientHelper.addItemRenderersRegistration(ClientRegistry::registerItemRenderers);
        ClientHelper.addTooltipComponentRegistration(ClientRegistry::registerTooltipComponents);
        ClientHelper.addBlockColorsRegistration(ClientRegistry::registerBlockColors);
    }

    private static void setup() {
        ModBlocks.ALT_RENDERED_BLOCKS.forEach((block, renderType) -> {
            if (renderType.equals("CUTOUT")) {
                ClientHelper.registerRenderType((Block)((Block)block.get()), (RenderType)RenderType.cutout());
            }
        });
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(ModBlockEntities.CRATE_BE_TYPE.get(), CrateRenderer::new);
    }

    private static void registerItemRenderers(ClientHelper.ItemRendererEvent event) {
        for (Block block : ModBlocks.getCrates()) {
            event.register((ItemLike)block, (ItemStackRenderer)new CrateItemRenderer());
        }
    }

    private static void registerTooltipComponents(ClientHelper.TooltipComponentEvent event) {
        event.register(CrateTooltip.class, ClientCrateTooltip::new);
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        event.register((state, view, pos, tintIndex) -> RedStoneWireBlock.getColorForPower((int)((Integer)state.getValue(((AnalogRailBlock)state.getBlock()).getPowerProperty()))), new Block[]{ModBlocks.ANALOG_RAIL.get()});
        event.register((state, view, pos, tintIndex) -> RedstoneLedBlock.getColorForPower((Integer)state.getValue(((RedstoneLedBlock)state.getBlock()).getPowerProperty())), new Block[]{ModBlocks.REDSTONE_LED.get()});
    }
}

