/*
 * Decompiled with CFR 0.152.
 */
package dev.chililisoup.condiments.reg;

import dev.chililisoup.condiments.Condiments;
import dev.chililisoup.condiments.block.AnalogRailBlock;
import dev.chililisoup.condiments.block.CopperFireBlock;
import dev.chililisoup.condiments.block.CrateBlock;
import dev.chililisoup.condiments.block.RailIntersectionBlock;
import dev.chililisoup.condiments.block.RedstoneLedBlock;
import dev.chililisoup.condiments.block.SaucerLightBlock;
import dev.chililisoup.condiments.block.WaxedIronBlock;
import dev.chililisoup.condiments.block.entity.CrateContents;
import dev.chililisoup.condiments.item.CrateItem;
import dev.chililisoup.condiments.reg.ModComponents;
import dev.chililisoup.condiments.reg.ModItems;
import java.util.HashMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class ModBlocks {
    public static final HashMap<Supplier<Block>, String> ALT_RENDERED_BLOCKS = new HashMap();
    public static final Supplier<Block> RAIL_INTERSECTION = ModBlocks.addBlock(new Params("rail_intersection", () -> new RailIntersectionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAIL))).cutout());
    public static final Supplier<Block> ANALOG_RAIL = ModBlocks.addBlock(new Params("analog_rail", () -> new AnalogRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POWERED_RAIL))).cutout());
    public static final Supplier<Block> CRATE = ModBlocks.addCrate("crate", null);
    public static final Supplier<Block> WHITE_CRATE = ModBlocks.addCrate("white_crate", DyeColor.WHITE);
    public static final Supplier<Block> LIGHT_GRAY_CRATE = ModBlocks.addCrate("light_gray_crate", DyeColor.LIGHT_GRAY);
    public static final Supplier<Block> GRAY_CRATE = ModBlocks.addCrate("gray_crate", DyeColor.GRAY);
    public static final Supplier<Block> BLACK_CRATE = ModBlocks.addCrate("black_crate", DyeColor.BLACK);
    public static final Supplier<Block> BROWN_CRATE = ModBlocks.addCrate("brown_crate", DyeColor.BROWN);
    public static final Supplier<Block> RED_CRATE = ModBlocks.addCrate("red_crate", DyeColor.RED);
    public static final Supplier<Block> ORANGE_CRATE = ModBlocks.addCrate("orange_crate", DyeColor.ORANGE);
    public static final Supplier<Block> YELLOW_CRATE = ModBlocks.addCrate("yellow_crate", DyeColor.YELLOW);
    public static final Supplier<Block> LIME_CRATE = ModBlocks.addCrate("lime_crate", DyeColor.LIME);
    public static final Supplier<Block> GREEN_CRATE = ModBlocks.addCrate("green_crate", DyeColor.GREEN);
    public static final Supplier<Block> CYAN_CRATE = ModBlocks.addCrate("cyan_crate", DyeColor.CYAN);
    public static final Supplier<Block> LIGHT_BLUE_CRATE = ModBlocks.addCrate("light_blue_crate", DyeColor.LIGHT_BLUE);
    public static final Supplier<Block> BLUE_CRATE = ModBlocks.addCrate("blue_crate", DyeColor.BLUE);
    public static final Supplier<Block> PURPLE_CRATE = ModBlocks.addCrate("purple_crate", DyeColor.PURPLE);
    public static final Supplier<Block> MAGENTA_CRATE = ModBlocks.addCrate("magenta_crate", DyeColor.MAGENTA);
    public static final Supplier<Block> PINK_CRATE = ModBlocks.addCrate("pink_crate", DyeColor.PINK);
    public static final Supplier<Block> WAXED_IRON_BLOCK = ModBlocks.addBlock(new Params("waxed_iron_block", () -> new WaxedIronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK))));
    public static final Supplier<Block> BLACKENED_IRON_BLOCK = ModBlocks.addBlock(new Params("blackened_iron_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK))));
    public static final Supplier<Block> BLACKENED_IRON_GRATE = ModBlocks.addBlock(new Params("blackened_iron_grate", () -> new WaterloggedTransparentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS))).cutout());
    public static final Supplier<Block> BLACKENED_IRON_BARS = ModBlocks.addBlock(new Params("blackened_iron_bars", () -> new IronBarsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS))).cutout());
    public static final Supplier<Block> BLACKENED_IRON_DOOR = ModBlocks.addBlock(new Params("blackened_iron_door", () -> new DoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_DOOR))).cutout());
    public static final Supplier<Block> BLACKENED_IRON_TRAPDOOR = ModBlocks.addBlock(new Params("blackened_iron_trapdoor", () -> new TrapDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_TRAPDOOR))).cutout());
    public static final Supplier<Block> REDSTONE_LED = ModBlocks.addBlock(new Params("redstone_led", () -> new RedstoneLedBlock(BlockBehaviour.Properties.of().strength(0.3f).sound(SoundType.GLASS).lightLevel(state -> 1).emissiveRendering(ModBlocks::always))).cutout());
    public static final Supplier<Block> SAUCER_LIGHT = ModBlocks.addBlock(new Params("saucer_light", () -> new SaucerLightBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0).pushReaction(PushReaction.NORMAL))));
    public static final Supplier<Block> COPPER_FIRE = ModBlocks.addBlock(new Params("copper_fire", () -> new CopperFireBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_FIRE).mapColor(MapColor.COLOR_LIGHT_GREEN))).noItem().cutout());

    private static Supplier<Block> addBlock(Params params) {
        RegSupplier regSupplier = RegHelper.registerBlock((ResourceLocation)Condiments.loc(params.id), params.blockFactory);
        Supplier<Block> blockSupplier = () -> ((RegSupplier)regSupplier).get();
        if (params.createItem) {
            ModItems.addItem(params.getItemParams(blockSupplier));
        }
        if (params.renderType != null && PlatHelper.getPhysicalSide().isClient()) {
            ALT_RENDERED_BLOCKS.put(blockSupplier, params.renderType);
        }
        return blockSupplier;
    }

    public static void init() {
    }

    private static Supplier<Block> addCrate(String id, DyeColor color) {
        return ModBlocks.addBlock(new CrateParams(id, () -> new CrateBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL).pushReaction(PushReaction.DESTROY))));
    }

    public static Block[] getCrates() {
        return new Block[]{CRATE.get(), WHITE_CRATE.get(), LIGHT_GRAY_CRATE.get(), GRAY_CRATE.get(), BLACK_CRATE.get(), BROWN_CRATE.get(), RED_CRATE.get(), ORANGE_CRATE.get(), YELLOW_CRATE.get(), LIME_CRATE.get(), GREEN_CRATE.get(), CYAN_CRATE.get(), LIGHT_BLUE_CRATE.get(), BLUE_CRATE.get(), PURPLE_CRATE.get(), MAGENTA_CRATE.get(), PINK_CRATE.get()};
    }

    public static boolean always(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    public static class Params {
        public final String id;
        public final Supplier<? extends Block> blockFactory;
        public boolean createItem = true;
        public String renderType = null;

        public Params(String id, Supplier<? extends Block> blockFactory) {
            this.id = id;
            this.blockFactory = blockFactory;
        }

        public ModItems.Params getItemParams(Supplier<? extends Block> block) {
            return new ModItems.Params(this.id, () -> this.getItem(block));
        }

        public BlockItem getItem(Supplier<? extends Block> block) {
            return new BlockItem(block.get(), new Item.Properties());
        }

        public Params noItem() {
            this.createItem = false;
            return this;
        }

        public Params cutout() {
            this.renderType = "CUTOUT";
            return this;
        }
    }

    public static class CrateParams
    extends Params {
        CrateParams(String id, Supplier<? extends Block> blockFactory) {
            super(id, blockFactory);
        }

        @Override
        public BlockItem getItem(Supplier<? extends Block> block) {
            return new CrateItem(block.get(), new Item.Properties().component(ModComponents.CRATE_CONTENTS.get(), (Object)CrateContents.EMPTY));
        }
    }
}

