/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.block.entity;

import com.google.common.collect.Multimap;
import dev.bluesheep.nanomirai.NanoMirai;
import dev.bluesheep.nanomirai.item.NanoSwarmBlasterItem;
import dev.bluesheep.nanomirai.item.SupportNanoItem;
import dev.bluesheep.nanomirai.recipe.lab.NanoLabRecipeInput;
import dev.bluesheep.nanomirai.recipe.lab.attribute.LabAttributeRecipe;
import dev.bluesheep.nanomirai.recipe.lab.effect.LabEffectRecipe;
import dev.bluesheep.nanomirai.registry.NanoMiraiBlockEntities;
import dev.bluesheep.nanomirai.registry.NanoMiraiItems;
import dev.bluesheep.nanomirai.registry.NanoMiraiRecipeType;
import dev.bluesheep.nanomirai.util.NanoTier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 :2\u00020\u0001:\u0001:B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\u0006\u0010$\u001a\u00020\u001aJ\u001e\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0005J\b\u0010)\u001a\u00020\u001aH\u0002J\b\u0010*\u001a\u00020\u001aH\u0002J\b\u0010+\u001a\u00020\u001aH\u0002J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u001aH\u0002J\b\u0010/\u001a\u00020-H\u0002J\b\u00100\u001a\u00020-H\u0002J\u0014\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002040302H\u0002J\u0014\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002060302H\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006;"}, d2={"Ldev/bluesheep/nanomirai/block/entity/NanoLabBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "progress", "", "getProgress", "()I", "setProgress", "(I)V", "maxProgress", "getMaxProgress", "setMaxProgress", "data", "Lnet/minecraft/world/inventory/ContainerData;", "getData", "()Lnet/minecraft/world/inventory/ContainerData;", "loadAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "getUpdateTag", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "drops", "tick", "level", "Lnet/minecraft/world/level/Level;", "state", "resetProgress", "craftItem", "consumeIngredients", "hasCraftingFinished", "", "increaseCraftingProgress", "hasRecipe", "isCraftable", "getCurrentAttributeRecipe", "Ljava/util/Optional;", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "Ldev/bluesheep/nanomirai/recipe/lab/attribute/LabAttributeRecipe;", "getCurrentEffectRecipe", "Ldev/bluesheep/nanomirai/recipe/lab/effect/LabEffectRecipe;", "inputList", "", "Lnet/minecraft/world/item/ItemStack;", "Companion", "nanomirai"})
public final class NanoLabBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStackHandler itemHandler;
    private int progress;
    private int maxProgress;
    @NotNull
    private final ContainerData data;
    public static final int SIZE = 8;
    public static final int OUTPUT_SLOT = 0;
    public static final int CATALYST_SLOT = 1;

    public NanoLabBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(NanoMiraiBlockEntities.INSTANCE.getNANO_LAB(), pos, blockState);
        this.itemHandler = new ItemStackHandler(8);
        this.maxProgress = 100;
        this.data = new ContainerData(this){
            final /* synthetic */ NanoLabBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public int get(int index) {
                return switch (index) {
                    case 0 -> this.this$0.getProgress();
                    case 1 -> this.this$0.getMaxProgress();
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        this.this$0.setProgress(value);
                        break;
                    }
                    case 1: {
                        this.this$0.setMaxProgress(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public final ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int n) {
        this.progress = n;
    }

    public final int getMaxProgress() {
        return this.maxProgress;
    }

    public final void setMaxProgress(int n) {
        this.maxProgress = n;
    }

    @NotNull
    public final ContainerData getData() {
        return this.data;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("items"));
        this.progress = tag.getInt("progress");
        this.maxProgress = tag.getInt("maxProgress");
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        tag.put("items", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("progress", this.progress);
        tag.putInt("maxProgress", this.maxProgress);
        super.saveAdditional(tag, registries);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    public final void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        int n = inventory.getContainerSize();
        for (int i = 0; i < n; ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)((Container)inventory));
    }

    public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.hasRecipe() && this.isCraftable()) {
            this.increaseCraftingProgress();
            BlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private final void resetProgress() {
        this.progress = 0;
        this.maxProgress = 100;
    }

    private final void craftItem() {
        Optional<RecipeHolder<LabEffectRecipe>> effectRecipe;
        Optional<RecipeHolder<LabAttributeRecipe>> attributeRecipe = this.getCurrentAttributeRecipe();
        if (!attributeRecipe.isEmpty()) {
            Holder<Attribute> attribute = ((LabAttributeRecipe)attributeRecipe.get().value()).getAttribute();
            AttributeModifier modifier = ((LabAttributeRecipe)attributeRecipe.get().value()).getModifier();
            this.consumeIngredients();
            ItemStack itemStack = this.itemHandler.getStackInSlot(0);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
            SupportNanoItem.Companion.setAttributes(itemStack, attribute, modifier);
        }
        if (!(effectRecipe = this.getCurrentEffectRecipe()).isEmpty()) {
            this.consumeIngredients();
            ItemStack itemStack = this.itemHandler.getStackInSlot(0);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
            NanoSwarmBlasterItem.Companion.addEffect(itemStack, ((LabEffectRecipe)effectRecipe.get().value()).getMobEffectInstance());
        }
    }

    private final void consumeIngredients() {
        for (int i = 2; i < 8; ++i) {
            this.itemHandler.getStackInSlot(i).shrink(1);
        }
    }

    private final boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private final void increaseCraftingProgress() {
        int n = this.progress;
        this.progress = n + 1;
    }

    private final boolean hasRecipe() {
        Optional<RecipeHolder<LabAttributeRecipe>> attributeRecipe = this.getCurrentAttributeRecipe();
        Optional<RecipeHolder<LabEffectRecipe>> effectRecipe = this.getCurrentEffectRecipe();
        return attributeRecipe.isPresent() && this.itemHandler.getStackInSlot(0).is((Item)NanoMiraiItems.INSTANCE.getSUPPORT_NANO()) || effectRecipe.isPresent() && this.itemHandler.getStackInSlot(0).is((Item)NanoMiraiItems.INSTANCE.getNANO_SWARM_BLASTER());
    }

    private final boolean isCraftable() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        Item item = stack.getItem();
        if (item instanceof SupportNanoItem) {
            Optional<RecipeHolder<LabAttributeRecipe>> recipe = this.getCurrentAttributeRecipe();
            if (recipe.isEmpty()) {
                return false;
            }
            Rarity rarity = stack.getRarity();
            Intrinsics.checkNotNullExpressionValue((Object)rarity, (String)"getRarity(...)");
            NanoTier tier = NanoTier.Companion.fromRarity(rarity);
            Multimap currentAttributes = CuriosApi.getAttributeModifiers((SlotContext)new SlotContext("support_nano", null, 0, false, true), (ResourceLocation)NanoMirai.INSTANCE.rl("support_nano"), (ItemStack)stack);
            return currentAttributes.size() < tier.getMaxAttributes() && !currentAttributes.containsKey(((LabAttributeRecipe)recipe.get().value()).getAttribute());
        }
        if (item instanceof NanoSwarmBlasterItem) {
            Object currentEffects;
            Optional<RecipeHolder<LabEffectRecipe>> recipe = this.getCurrentEffectRecipe();
            if (recipe.isEmpty()) {
                return false;
            }
            Rarity rarity = stack.getRarity();
            Intrinsics.checkNotNullExpressionValue((Object)rarity, (String)"getRarity(...)");
            NanoTier tier = NanoTier.Companion.fromRarity(rarity);
            Object object = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (object == null || (object = object.customEffects()) == null) {
                object = CollectionsKt.emptyList();
            }
            return (currentEffects = object).size() < tier.getMaxEffects() && !currentEffects.contains(((LabEffectRecipe)recipe.get().value()).getMobEffectInstance());
        }
        return false;
    }

    private final Optional<RecipeHolder<LabAttributeRecipe>> getCurrentAttributeRecipe() {
        if (this.level == null) {
            Optional<RecipeHolder<LabAttributeRecipe>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        RecipeManager recipeManager = level.getRecipeManager();
        RecipeType<LabAttributeRecipe> recipeType = NanoMiraiRecipeType.INSTANCE.getLAB_ATTRIBUTE();
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack itemStack2 = this.itemHandler.getStackInSlot(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackInSlot(...)");
        RecipeInput recipeInput = new NanoLabRecipeInput(itemStack, itemStack2, this.inputList());
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        Optional optional = recipeManager.getRecipeFor(recipeType, recipeInput, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
        return optional;
    }

    private final Optional<RecipeHolder<LabEffectRecipe>> getCurrentEffectRecipe() {
        if (this.level == null) {
            Optional<RecipeHolder<LabEffectRecipe>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        RecipeManager recipeManager = level.getRecipeManager();
        RecipeType<LabEffectRecipe> recipeType = NanoMiraiRecipeType.INSTANCE.getLAB_EFFECT();
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack itemStack2 = this.itemHandler.getStackInSlot(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackInSlot(...)");
        RecipeInput recipeInput = new NanoLabRecipeInput(itemStack, itemStack2, this.inputList());
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        Optional optional = recipeManager.getRecipeFor(recipeType, recipeInput, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
        return optional;
    }

    private final List<ItemStack> inputList() {
        List list = new ArrayList();
        for (int i = 2; i < 8; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Intrinsics.checkNotNull((Object)stack);
            list.add(stack);
        }
        return list;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/bluesheep/nanomirai/block/entity/NanoLabBlockEntity$Companion;", "", "<init>", "()V", "SIZE", "", "OUTPUT_SLOT", "CATALYST_SLOT", "nanomirai"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

