/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.block.entity;

import com.mojang.serialization.DynamicOps;
import dev.bluesheep.nanomirai.block.SynthesizeDisplayBlock;
import dev.bluesheep.nanomirai.recipe.BlockWithPairItemInput;
import dev.bluesheep.nanomirai.recipe.synthesize.SynthesizeRecipe;
import dev.bluesheep.nanomirai.registry.NanoMiraiBlockEntities;
import dev.bluesheep.nanomirai.registry.NanoMiraiRecipeType;
import dev.bluesheep.nanomirai.util.NanoTier;
import dev.bluesheep.nanomirai.util.SynthesizeState;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\u0006\u0010&\u001a\u00020\u001cJ\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)J\u001e\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0006J\u0018\u0010/\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u00100\u001a\u00020\u001cH\u0002J\u0010\u00101\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u00102\u001a\u000203J\b\u00104\u001a\u00020\u001cH\u0002J\b\u00105\u001a\u000203H\u0002J\u0014\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090807H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\"\u0010>\u001a\u0002032\u0006\u0010<\u001a\u00020\u00132\u0006\u0010?\u001a\u00020)2\b\u0010@\u001a\u0004\u0018\u00010=H\u0016J \u0010A\u001a\u0002032\u0006\u0010<\u001a\u00020\u00132\u0006\u0010?\u001a\u00020)2\u0006\u0010@\u001a\u00020=H\u0016J\b\u0010B\u001a\u00020\u0013H\u0016J\b\u0010C\u001a\u000203H\u0016J\u0010\u0010D\u001a\u00020)2\u0006\u0010<\u001a\u00020\u0013H\u0016J\u0018\u0010E\u001a\u00020)2\u0006\u0010<\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u0013H\u0016J\u0010\u0010F\u001a\u00020)2\u0006\u0010<\u001a\u00020\u0013H\u0016J\u0018\u0010G\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010H\u001a\u0002032\u0006\u0010<\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020\u001cH\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u0006K"}, d2={"Ldev/bluesheep/nanomirai/block/entity/SynthesizeDisplayBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "block", "getBlock", "()Lnet/minecraft/world/level/block/state/BlockState;", "setBlock", "(Lnet/minecraft/world/level/block/state/BlockState;)V", "progress", "", "getProgress", "()I", "setProgress", "(I)V", "maxProgress", "getMaxProgress", "setMaxProgress", "loadAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "getUpdateTag", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "drops", "setPrimaryItem", "stack", "Lnet/minecraft/world/item/ItemStack;", "setSecondaryItem", "tick", "level", "Lnet/minecraft/world/level/Level;", "state", "spawnParticles", "startCrafting", "craftItem", "hasCraftingFinished", "", "increaseCraftingProgress", "hasRecipe", "getCurrentRecipe", "Ljava/util/Optional;", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "Ldev/bluesheep/nanomirai/recipe/synthesize/SynthesizeRecipe;", "getSlotsForFace", "", "p0", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "p1", "p2", "canTakeItemThroughFace", "getContainerSize", "isEmpty", "getItem", "removeItem", "removeItemNoUpdate", "setItem", "stillValid", "Lnet/minecraft/world/entity/player/Player;", "clearContent", "nanomirai"})
public final class SynthesizeDisplayBlockEntity
extends BlockEntity
implements WorldlyContainer {
    @NotNull
    private final ItemStackHandler itemHandler;
    @NotNull
    private BlockState block;
    private int progress;
    private int maxProgress;

    public SynthesizeDisplayBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(NanoMiraiBlockEntities.INSTANCE.getSYNTHESIZE_DISPLAY(), pos, blockState);
        this.itemHandler = new ItemStackHandler(2);
        BlockState blockState2 = Blocks.AIR.defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        this.block = blockState2;
        this.maxProgress = 100;
    }

    @NotNull
    public final ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @NotNull
    public final BlockState getBlock() {
        return this.block;
    }

    public final void setBlock(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<set-?>");
        this.block = blockState;
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int n) {
        this.progress = n;
    }

    public final int getMaxProgress() {
        return this.maxProgress;
    }

    public final void setMaxProgress(int n) {
        this.maxProgress = n;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("items"));
        BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("block")).result().ifPresent(arg_0 -> SynthesizeDisplayBlockEntity.loadAdditional$lambda$1(arg_0 -> SynthesizeDisplayBlockEntity.loadAdditional$lambda$0(this, arg_0), arg_0));
        this.progress = tag.getInt("progress");
        this.maxProgress = tag.getInt("maxProgress");
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        tag.put("items", (Tag)this.itemHandler.serializeNBT(registries));
        BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.block).result().ifPresent(arg_0 -> SynthesizeDisplayBlockEntity.saveAdditional$lambda$3(arg_0 -> SynthesizeDisplayBlockEntity.saveAdditional$lambda$2(tag, arg_0), arg_0));
        tag.putInt("progress", this.progress);
        tag.putInt("maxProgress", this.maxProgress);
        super.saveAdditional(tag, registries);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    public final void drops() {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.setItem(0, this.itemHandler.getStackInSlot(1));
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition.above(), (Container)((Container)inventory));
    }

    public final void setPrimaryItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.itemHandler.setStackInSlot(0, stack);
        this.setChanged();
    }

    public final void setSecondaryItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.itemHandler.setStackInSlot(1, stack);
        this.startCrafting();
        this.setChanged();
    }

    public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.itemHandler.getStackInSlot(1).isEmpty() && this.hasRecipe()) {
            this.increaseCraftingProgress();
            this.spawnParticles(level, pos);
            BlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem(level);
            }
        }
    }

    private final void spawnParticles(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        Vec3 center = pos.getCenter();
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, center.x, center.y, center.z, 1, 0.3, 0.3, 0.3, 0.2);
        if (this.progress % 5 != 0) {
            return;
        }
        ((ServerLevel)level).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.itemHandler.getStackInSlot(1)), center.x, center.y, center.z, 5, 0.3, 0.3, 0.3, 0.1);
    }

    private final void startCrafting() {
        Optional<RecipeHolder<SynthesizeRecipe>> recipe = this.getCurrentRecipe();
        SynthesizeState state = SynthesizeState.INVALID;
        if (recipe.isPresent()) {
            state = SynthesizeState.CRAFTING;
            Rarity rarity = (Rarity)this.itemHandler.getStackInSlot(0).get(DataComponents.RARITY);
            if (rarity == null) {
                rarity = Rarity.COMMON;
            }
            NanoTier tier = NanoTier.Companion.fromRarity(rarity);
            this.maxProgress = (int)((double)((SynthesizeRecipe)recipe.get().value()).getDuration() / tier.getProcessingSpeedMultiplier());
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SynthesizeDisplayBlock.Companion.getSTATE(), (Comparable)((Object)state)));
        this.setChanged();
    }

    private final void craftItem(Level level) {
        Optional<RecipeHolder<SynthesizeRecipe>> recipe = this.getCurrentRecipe();
        ItemStack output = ((SynthesizeRecipe)recipe.get().value()).getResult().copy();
        Item outputItem = output.getItem();
        if (outputItem instanceof BlockItem) {
            v0 = level.setBlockAndUpdate(this.worldPosition, ((BlockItem)outputItem).getBlock().defaultBlockState());
        } else {
            SimpleContainer inventory = new SimpleContainer(1);
            inventory.setItem(0, output);
            Containers.dropContents((Level)level, (BlockPos)this.worldPosition, (Container)((Container)inventory));
            v0 = level.removeBlock(this.worldPosition, false);
        }
    }

    public final boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private final void increaseCraftingProgress() {
        int n = this.progress;
        this.progress = n + 1;
    }

    private final boolean hasRecipe() {
        return this.getCurrentRecipe().isPresent();
    }

    private final Optional<RecipeHolder<SynthesizeRecipe>> getCurrentRecipe() {
        if (this.level == null) {
            Optional<RecipeHolder<SynthesizeRecipe>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        RecipeManager recipeManager = level.getRecipeManager();
        RecipeType<SynthesizeRecipe> recipeType = NanoMiraiRecipeType.INSTANCE.getSYNTHESIZE();
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack itemStack2 = this.itemHandler.getStackInSlot(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackInSlot(...)");
        RecipeInput recipeInput = new BlockWithPairItemInput(this.block, itemStack, itemStack2);
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        Optional optional = recipeManager.getRecipeFor(recipeType, recipeInput, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
        return optional;
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        int[] nArray = new int[]{1};
        return nArray;
    }

    public boolean canPlaceItemThroughFace(int p0, @NotNull ItemStack p1, @Nullable Direction p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.itemHandler.getStackInSlot(1).isEmpty();
    }

    public boolean canTakeItemThroughFace(int p0, @NotNull ItemStack p1, @NotNull Direction p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return false;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.itemHandler.getStackInSlot(1).isEmpty();
    }

    @NotNull
    public ItemStack getItem(int p0) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItem(int p0, int p1) {
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int p0) {
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public void setItem(int p0, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.setSecondaryItem(stack);
    }

    public boolean stillValid(@NotNull Player p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return false;
    }

    public void clearContent() {
    }

    private static final Unit loadAdditional$lambda$0(SynthesizeDisplayBlockEntity this$0, BlockState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this$0.block = state;
        return Unit.INSTANCE;
    }

    private static final void loadAdditional$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit saveAdditional$lambda$2(CompoundTag $tag, Tag it) {
        Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $tag.put("block", it);
        return Unit.INSTANCE;
    }

    private static final void saveAdditional$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

