/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.item;

import dev.bluesheep.nanomirai.registry.NanoMiraiItems;
import dev.bluesheep.nanomirai.util.NanoTier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Ldev/bluesheep/nanomirai/item/INanoTieredItem;", "", "getTieredName", "Lnet/minecraft/network/chat/Component;", "stack", "Lnet/minecraft/world/item/ItemStack;", "nameComponent", "otherStackedOnMe", "", "other", "action", "Lnet/minecraft/world/inventory/ClickAction;", "repair", "", "material", "nanomirai"})
public interface INanoTieredItem {
    @NotNull
    public Component getTieredName(@NotNull ItemStack var1, @NotNull Component var2);

    public boolean otherStackedOnMe(@NotNull ItemStack var1, @NotNull ItemStack var2, @NotNull ClickAction var3);

    public void repair(@NotNull ItemStack var1, @NotNull ItemStack var2);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Component getTieredName(@NotNull INanoTieredItem $this, @NotNull ItemStack stack, @NotNull Component nameComponent) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)nameComponent, (String)"nameComponent");
            MutableComponent mutableComponent = nameComponent.copy().append(" ");
            Rarity rarity = stack.getRarity();
            Intrinsics.checkNotNullExpressionValue((Object)rarity, (String)"getRarity(...)");
            MutableComponent mutableComponent2 = mutableComponent.append(NanoTier.Companion.fromRarity(rarity).getNameComponent());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"append(...)");
            return (Component)mutableComponent2;
        }

        public static boolean otherStackedOnMe(@NotNull INanoTieredItem $this, @NotNull ItemStack stack, @NotNull ItemStack other, @NotNull ClickAction action) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            if (action != ClickAction.SECONDARY) {
                return false;
            }
            if (!other.is(NanoMiraiItems.INSTANCE.getREPAIR_NANO())) {
                return false;
            }
            if (stack.isDamaged()) {
                $this.repair(stack, other);
            }
            return true;
        }

        public static void repair(@NotNull INanoTieredItem $this, @NotNull ItemStack stack, @NotNull ItemStack material) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)material, (String)"material");
            int n = stack.getDamageValue();
            stack.setDamageValue(n + -1);
            material.shrink(1);
        }
    }
}

