/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.item;

import dev.bluesheep.nanomirai.item.INanoTieredItem;
import dev.bluesheep.nanomirai.registry.NanoMiraiItems;
import dev.bluesheep.nanomirai.util.NanoTier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J(\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J8\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*H\u0016\u00a8\u0006,"}, d2={"Ldev/bluesheep/nanomirai/item/NanoSwarmBlasterItem;", "Lnet/minecraft/world/item/Item;", "Ldev/bluesheep/nanomirai/item/INanoTieredItem;", "<init>", "()V", "getName", "Lnet/minecraft/network/chat/Component;", "stack", "Lnet/minecraft/world/item/ItemStack;", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "getUseDuration", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "releaseUsing", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "timeCharged", "use", "Lnet/minecraft/world/InteractionResultHolder;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "overrideOtherStackedOnMe", "", "other", "slot", "Lnet/minecraft/world/inventory/Slot;", "action", "Lnet/minecraft/world/inventory/ClickAction;", "access", "Lnet/minecraft/world/entity/SlotAccess;", "Companion", "nanomirai"})
@SourceDebugExtension(value={"SMAP\nNanoSwarmBlasterItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NanoSwarmBlasterItem.kt\ndev/bluesheep/nanomirai/item/NanoSwarmBlasterItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1869#2,2:143\n1011#2,2:145\n*S KotlinDebug\n*F\n+ 1 NanoSwarmBlasterItem.kt\ndev/bluesheep/nanomirai/item/NanoSwarmBlasterItem\n*L\n91#1:143,2\n120#1:145,2\n*E\n"})
public final class NanoSwarmBlasterItem
extends Item
implements INanoTieredItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public NanoSwarmBlasterItem() {
        super(new Item.Properties().stacksTo(1).component(DataComponents.MAX_DAMAGE, (Object)10).component(DataComponents.DAMAGE, (Object)0).component(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY));
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Component component = super.getName(stack);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        return this.getTieredName(stack, component);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            potionContents = PotionContents.EMPTY;
        }
        PotionContents potion = potionContents;
        potion.addPotionTooltip(p0 -> tooltipComponents.add((Component)p0), 1.0f, context.tickRate());
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 72000;
    }

    /*
     * WARNING - void declaration
     */
    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeCharged) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (!(livingEntity instanceof Player)) {
            return;
        }
        if (this.getUseDuration(stack, livingEntity) - timeCharged < 10) {
            return;
        }
        if (stack.getDamageValue() < stack.getMaxDamage() - 1) {
            if (!level.isClientSide && level instanceof ServerLevel) {
                void $this$forEach$iv;
                Vec3 origin = ((Player)livingEntity).getEyePosition();
                Vec3 target = origin.add(((Player)livingEntity).getLookAngle().normalize().scale(3.0)).subtract(origin);
                Vec3 end = origin.add(target.normalize().scale(9.6));
                for (int i = 2; i < 8; ++i) {
                    Vec3 pos = origin.add(target.normalize().scale((double)i * 1.2));
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                List list = level.getEntitiesOfClass(LivingEntity.class, new AABB(origin, end).inflate(0.5), arg_0 -> NanoSwarmBlasterItem.releaseUsing$lambda$1(arg_0 -> NanoSwarmBlasterItem.releaseUsing$lambda$0(origin, end, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
                Iterable i = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LivingEntity mob = (LivingEntity)element$iv;
                    boolean bl = false;
                    PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                    if (potionContents == null) continue;
                    potionContents.forEachEffect(arg_0 -> NanoSwarmBlasterItem.releaseUsing$lambda$3$lambda$2(mob, arg_0));
                }
                stack.hurtAndBreak(1, livingEntity, ((Player)livingEntity).getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
            ItemCooldowns itemCooldowns = ((Player)livingEntity).getCooldowns();
            Item item = this;
            Rarity rarity = stack.getRarity();
            Intrinsics.checkNotNullExpressionValue((Object)rarity, (String)"getRarity(...)");
            itemCooldowns.addCooldown(item, NanoTier.Companion.fromRarity(rarity).getBlasterCooldown());
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isCrouching()) {
            if (stack.isDamaged()) {
                Inventory inventory = player.getInventory();
                List repairMaterials = new ArrayList();
                int n = inventory.getContainerSize();
                for (int i = 0; i < n; ++i) {
                    ItemStack item = inventory.getItem(i);
                    if (!item.is(NanoMiraiItems.INSTANCE.getREPAIR_NANO())) continue;
                    Intrinsics.checkNotNull((Object)item);
                    repairMaterials.add(item);
                }
                if (!repairMaterials.isEmpty()) {
                    List $this$sortBy$iv = repairMaterials;
                    boolean $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                ItemStack p0 = (ItemStack)a;
                                boolean bl = false;
                                Comparable comparable = Integer.valueOf(p0.getCount());
                                p0 = (ItemStack)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getCount()));
                            }
                        });
                    }
                    Intrinsics.checkNotNull((Object)stack);
                    this.repair(stack, (ItemStack)CollectionsKt.first((List)repairMaterials));
                    InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)stack);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
                    return interactionResultHolder;
                }
            }
        } else {
            player.startUsingItem(usedHand);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
        return interactionResultHolder;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        return this.otherStackedOnMe(stack, other, action);
    }

    @Override
    @NotNull
    public Component getTieredName(@NotNull ItemStack stack, @NotNull Component nameComponent) {
        return INanoTieredItem.DefaultImpls.getTieredName(this, stack, nameComponent);
    }

    @Override
    public boolean otherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull ClickAction action) {
        return INanoTieredItem.DefaultImpls.otherStackedOnMe(this, stack, other, action);
    }

    @Override
    public void repair(@NotNull ItemStack stack, @NotNull ItemStack material) {
        INanoTieredItem.DefaultImpls.repair(this, stack, material);
    }

    private static final boolean releaseUsing$lambda$0(Vec3 $origin, Vec3 $end, LivingEntity mob) {
        return mob.getHitbox().inflate(0.5).clip($origin, $end).isPresent();
    }

    private static final boolean releaseUsing$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void releaseUsing$lambda$3$lambda$2(LivingEntity $mob, MobEffectInstance effect) {
        $mob.addEffect(new MobEffectInstance(effect));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ*\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Ldev/bluesheep/nanomirai/item/NanoSwarmBlasterItem$Companion;", "", "<init>", "()V", "addEffect", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "effect", "Lnet/minecraft/world/effect/MobEffectInstance;", "overrideProperty", "", "level", "Lnet/minecraft/client/multiplayer/ClientLevel;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "seed", "", "nanomirai"})
    @SourceDebugExtension(value={"SMAP\nNanoSwarmBlasterItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NanoSwarmBlasterItem.kt\ndev/bluesheep/nanomirai/item/NanoSwarmBlasterItem$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,142:1\n37#2:143\n36#2,3:144\n*S KotlinDebug\n*F\n+ 1 NanoSwarmBlasterItem.kt\ndev/bluesheep/nanomirai/item/NanoSwarmBlasterItem$Companion\n*L\n39#1:143\n39#1:144,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void addEffect(@NotNull ItemStack stack, @NotNull MobEffectInstance effect) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            if (!stack.is((Item)NanoMiraiItems.INSTANCE.getNANO_SWARM_BLASTER())) {
                return;
            }
            PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (potionContents == null) {
                potionContents = PotionContents.EMPTY;
            }
            PotionContents potion = potionContents;
            List list = potion.customEffects();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"customEffects(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            MobEffectInstance[] mobEffectInstanceArray = thisCollection$iv.toArray(new MobEffectInstance[0]);
            List effects = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(mobEffectInstanceArray, mobEffectInstanceArray.length));
            effects.add(effect);
            PotionContents newPotion = new PotionContents(Optional.empty(), Optional.empty(), effects);
            stack.set(DataComponents.POTION_CONTENTS, (Object)newPotion);
        }

        public final float overrideProperty(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (entity == null || entity.getUseItemRemainingTicks() == 0) {
                return 0.0f;
            }
            int usingItemTicks = stack.getUseDuration(entity) - entity.getUseItemRemainingTicks();
            return Mth.clamp((float)((float)usingItemTicks / 10.0f), (float)0.0f, (float)1.0f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

