/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.item;

import dev.bluesheep.nanomirai.block.entity.SynthesizeDisplayBlockEntity;
import dev.bluesheep.nanomirai.item.INanoTieredItem;
import dev.bluesheep.nanomirai.recipe.BlockWithPairItemInput;
import dev.bluesheep.nanomirai.recipe.synthesize.SynthesizeRecipe;
import dev.bluesheep.nanomirai.registry.NanoMiraiBlocks;
import dev.bluesheep.nanomirai.registry.NanoMiraiRecipeType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Ldev/bluesheep/nanomirai/item/SynthesizeNanoItem;", "Lnet/minecraft/world/item/Item;", "Ldev/bluesheep/nanomirai/item/INanoTieredItem;", "<init>", "()V", "getName", "Lnet/minecraft/network/chat/Component;", "stack", "Lnet/minecraft/world/item/ItemStack;", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "overrideOtherStackedOnMe", "", "other", "slot", "Lnet/minecraft/world/inventory/Slot;", "action", "Lnet/minecraft/world/inventory/ClickAction;", "player", "Lnet/minecraft/world/entity/player/Player;", "access", "Lnet/minecraft/world/entity/SlotAccess;", "DispenserBehavior", "nanomirai"})
public final class SynthesizeNanoItem
extends Item
implements INanoTieredItem {
    public SynthesizeNanoItem() {
        super(new Item.Properties().durability(8));
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Component component = super.getName(stack);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        return this.getTieredName(stack, component);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player player2 = player;
        BlockState inputBlock = context.getLevel().getBlockState(context.getClickedPos());
        ItemStack mainhand = player2.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack offhand = player2.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack primaryItem = context.getHand() == InteractionHand.MAIN_HAND ? mainhand : offhand;
        ItemStack secondaryItem = context.getHand() == InteractionHand.MAIN_HAND ? offhand : mainhand;
        RecipeManager recipeManager = level.getRecipeManager();
        RecipeType<SynthesizeRecipe> recipeType = NanoMiraiRecipeType.INSTANCE.getSYNTHESIZE();
        Intrinsics.checkNotNull((Object)inputBlock);
        Intrinsics.checkNotNull((Object)primaryItem);
        Intrinsics.checkNotNull((Object)secondaryItem);
        List recipe = recipeManager.getRecipesFor(recipeType, (RecipeInput)new BlockWithPairItemInput(inputBlock, primaryItem, secondaryItem), level);
        if (recipe.isEmpty()) {
            player2.displayClientMessage((Component)Component.translatable((String)"recipe.nanomirai.synthesize.not_found"), true);
            return InteractionResult.FAIL;
        }
        level.setBlock(context.getClickedPos(), NanoMiraiBlocks.INSTANCE.getSYNTHESIZE_DISPLAY().defaultBlockState(), 3);
        BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof SynthesizeDisplayBlockEntity) {
            ((SynthesizeDisplayBlockEntity)blockEntity).setBlock(inputBlock);
            SynthesizeDisplayBlockEntity synthesizeDisplayBlockEntity = (SynthesizeDisplayBlockEntity)blockEntity;
            ItemStack itemStack = primaryItem.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            synthesizeDisplayBlockEntity.setPrimaryItem(itemStack);
            SynthesizeDisplayBlockEntity synthesizeDisplayBlockEntity2 = (SynthesizeDisplayBlockEntity)blockEntity;
            ItemStack itemStack2 = secondaryItem.split(1);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"split(...)");
            synthesizeDisplayBlockEntity2.setSecondaryItem(itemStack2);
            primaryItem.hurtAndBreak(1, (LivingEntity)player2, context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            player2.displayClientMessage((Component)Component.translatable((String)"recipe.nanomirai.synthesize.start"), true);
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        return this.otherStackedOnMe(stack, other, action);
    }

    @Override
    @NotNull
    public Component getTieredName(@NotNull ItemStack stack, @NotNull Component nameComponent) {
        return INanoTieredItem.DefaultImpls.getTieredName(this, stack, nameComponent);
    }

    @Override
    public boolean otherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull ClickAction action) {
        return INanoTieredItem.DefaultImpls.otherStackedOnMe(this, stack, other, action);
    }

    @Override
    public void repair(@NotNull ItemStack stack, @NotNull ItemStack material) {
        INanoTieredItem.DefaultImpls.repair(this, stack, material);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0014\u00a8\u0006\t"}, d2={"Ldev/bluesheep/nanomirai/item/SynthesizeNanoItem$DispenserBehavior;", "Lnet/minecraft/core/dispenser/OptionalDispenseItemBehavior;", "<init>", "()V", "execute", "Lnet/minecraft/world/item/ItemStack;", "blockSource", "Lnet/minecraft/core/dispenser/BlockSource;", "itemStack", "nanomirai"})
    @SourceDebugExtension(value={"SMAP\nSynthesizeNanoItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynthesizeNanoItem.kt\ndev/bluesheep/nanomirai/item/SynthesizeNanoItem$DispenserBehavior\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1761#2,3:115\n*S KotlinDebug\n*F\n+ 1 SynthesizeNanoItem.kt\ndev/bluesheep/nanomirai/item/SynthesizeNanoItem$DispenserBehavior\n*L\n90#1:115,3\n*E\n"})
    public static final class DispenserBehavior
    extends OptionalDispenseItemBehavior {
        @NotNull
        protected ItemStack execute(@NotNull BlockSource blockSource, @NotNull ItemStack itemStack) {
            boolean hasRecipe;
            BlockState inputBlock;
            BlockPos inputBlockPos;
            ServerLevel level;
            block5: {
                Intrinsics.checkNotNullParameter((Object)blockSource, (String)"blockSource");
                Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
                this.setSuccess(false);
                level = blockSource.level();
                BlockState dispenser = blockSource.state();
                inputBlockPos = blockSource.pos().relative((Direction)dispenser.getValue((Property)DispenserBlock.FACING));
                inputBlock = blockSource.level().getBlockState(inputBlockPos);
                List list = level.getRecipeManager().getAllRecipesFor(NanoMiraiRecipeType.INSTANCE.getSYNTHESIZE());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllRecipesFor(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RecipeHolder it = (RecipeHolder)element$iv;
                        boolean bl = false;
                        if (!(inputBlock.is(((SynthesizeRecipe)it.value()).getInputBlock().getBlock()) && itemStack.getRarity().ordinal() >= ((SynthesizeRecipe)it.value()).getTier())) continue;
                        v1 = true;
                        break block5;
                    }
                    v1 = hasRecipe = false;
                }
            }
            if (!hasRecipe) {
                return itemStack;
            }
            level.setBlockAndUpdate(inputBlockPos, NanoMiraiBlocks.INSTANCE.getSYNTHESIZE_DISPLAY().defaultBlockState());
            BlockEntity blockEntity = level.getBlockEntity(inputBlockPos);
            if (blockEntity instanceof SynthesizeDisplayBlockEntity) {
                ((SynthesizeDisplayBlockEntity)blockEntity).setBlock(inputBlock);
                SynthesizeDisplayBlockEntity synthesizeDisplayBlockEntity = (SynthesizeDisplayBlockEntity)blockEntity;
                ItemStack itemStack2 = itemStack.copy();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"copy(...)");
                synthesizeDisplayBlockEntity.setPrimaryItem(itemStack2);
                itemStack.hurtAndBreak(1, level, null, DispenserBehavior::execute$lambda$1);
                this.setSuccess(true);
                return itemStack;
            }
            ItemStack itemStack3 = super.execute(blockSource, itemStack);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"execute(...)");
            return itemStack3;
        }

        private static final void execute$lambda$1(Item it) {
        }
    }
}

