/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.recipe.lab;

import dev.bluesheep.nanomirai.recipe.lab.NanoLabRecipeInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Ldev/bluesheep/nanomirai/recipe/lab/AbstractLabRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Ldev/bluesheep/nanomirai/recipe/lab/NanoLabRecipeInput;", "result", "Lnet/minecraft/world/item/ItemStack;", "tier", "", "catalyst", "Lnet/minecraft/world/item/crafting/Ingredient;", "items", "Lnet/minecraft/core/NonNullList;", "<init>", "(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/core/NonNullList;)V", "getResult", "()Lnet/minecraft/world/item/ItemStack;", "getTier", "()I", "getCatalyst", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getItems", "()Lnet/minecraft/core/NonNullList;", "getIngredients", "matches", "", "input", "level", "Lnet/minecraft/world/level/Level;", "canCraftInDimensions", "width", "height", "assemble", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getResultItem", "nanomirai"})
@SourceDebugExtension(value={"SMAP\nAbstractLabRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLabRecipe.kt\ndev/bluesheep/nanomirai/recipe/lab/AbstractLabRecipe\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n37#2:49\n36#2,3:50\n774#3:53\n865#3,2:54\n774#3:56\n865#3,2:57\n360#3,7:59\n*S KotlinDebug\n*F\n+ 1 AbstractLabRecipe.kt\ndev/bluesheep/nanomirai/recipe/lab/AbstractLabRecipe\n*L\n12#1:49\n12#1:50,3\n21#1:53\n21#1:54,2\n23#1:56\n23#1:57,2\n24#1:59,7\n*E\n"})
public abstract class AbstractLabRecipe
implements Recipe<NanoLabRecipeInput> {
    @NotNull
    private final ItemStack result;
    private final int tier;
    @NotNull
    private final Ingredient catalyst;
    @NotNull
    private final NonNullList<Ingredient> items;

    public AbstractLabRecipe(@NotNull ItemStack result, int tier, @NotNull Ingredient catalyst, @NotNull NonNullList<Ingredient> items) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)catalyst, (String)"catalyst");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.result = result;
        this.tier = tier;
        this.catalyst = catalyst;
        this.items = items;
    }

    @NotNull
    public final ItemStack getResult() {
        return this.result;
    }

    public final int getTier() {
        return this.tier;
    }

    @NotNull
    public final Ingredient getCatalyst() {
        return this.catalyst;
    }

    @NotNull
    public final NonNullList<Ingredient> getItems() {
        return this.items;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        Collection $this$toTypedArray$iv = (Collection)this.items;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Ingredient[] ingredientArray = thisCollection$iv.toArray(new Ingredient[0]);
        NonNullList nonNullList = NonNullList.of((Object)Ingredient.EMPTY, (Object[])Arrays.copyOf(ingredientArray, ingredientArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"of(...)");
        return nonNullList;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(@NotNull NanoLabRecipeInput input, @NotNull Level level) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!this.catalyst.test(input.getCatalyst())) {
            return false;
        }
        if (input.getNanoItem().getRarity().ordinal() < this.tier) {
            return false;
        }
        Iterable $this$filter$iv = input.getList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inputList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $this$filter$iv2 = (Iterable)this.getIngredients();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ingredient it = (Ingredient)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        for (Ingredient ingredient : (List)destination$iv$iv2) {
            int index;
            block8: {
                int n;
                List $this$indexOfFirst$iv = inputList;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    ItemStack it = (ItemStack)item$iv;
                    boolean bl = false;
                    if (ingredient.test(it)) {
                        n = index$iv;
                        break block8;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index == -1) {
                return false;
            }
            ItemStack cfr_ignored_0 = (ItemStack)inputList.remove(index);
        }
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.items.size();
    }

    @NotNull
    public ItemStack assemble(@NotNull NanoLabRecipeInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack itemStack = this.result.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        return this.result;
    }
}

