/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.recipe.laser;

import dev.bluesheep.nanomirai.recipe.DualRecipeInput;
import dev.bluesheep.nanomirai.registry.NanoMiraiRecipeSerializer;
import dev.bluesheep.nanomirai.registry.NanoMiraiRecipeType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0019H\u0016J\f\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\f\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006#"}, d2={"Ldev/bluesheep/nanomirai/recipe/laser/LaserRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Ldev/bluesheep/nanomirai/recipe/DualRecipeInput;", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "result", "Lnet/minecraft/world/item/ItemStack;", "lens", "<init>", "(Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/crafting/Ingredient;)V", "getIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getResult", "()Lnet/minecraft/world/item/ItemStack;", "getLens", "getIngredients", "Lnet/minecraft/core/NonNullList;", "matches", "", "input", "level", "Lnet/minecraft/world/level/Level;", "assemble", "p0", "p1", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "", "height", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "nanomirai"})
public final class LaserRecipe
implements Recipe<DualRecipeInput> {
    @NotNull
    private final Ingredient ingredient;
    @NotNull
    private final ItemStack result;
    @NotNull
    private final Ingredient lens;

    public LaserRecipe(@NotNull Ingredient ingredient, @NotNull ItemStack result, @NotNull Ingredient lens) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)lens, (String)"lens");
        this.ingredient = ingredient;
        this.result = result;
        this.lens = lens;
    }

    public /* synthetic */ LaserRecipe(Ingredient ingredient, ItemStack itemStack, Ingredient ingredient2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ingredient2 = Ingredient.EMPTY;
        }
        this(ingredient, itemStack, ingredient2);
    }

    @NotNull
    public final Ingredient getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public final ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public final Ingredient getLens() {
        return this.lens;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        Object[] objectArray = new Ingredient[]{this.ingredient, this.lens};
        NonNullList nonNullList = NonNullList.of((Object)Ingredient.EMPTY, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"of(...)");
        return nonNullList;
    }

    public boolean matches(@NotNull DualRecipeInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return this.ingredient.test(input.getFirst()) && (this.lens.isEmpty() || this.lens.test(input.getSecond()));
    }

    @NotNull
    public ItemStack assemble(@NotNull DualRecipeInput p0, @NotNull HolderLookup.Provider p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        ItemStack itemStack = this.result.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = NanoMiraiRecipeSerializer.INSTANCE.getLASER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    @NotNull
    public RecipeType<?> getType() {
        return NanoMiraiRecipeType.INSTANCE.getLASER();
    }
}

