/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.nanomirai.recipe.synthesize;

import dev.bluesheep.nanomirai.recipe.SimpleRecipeBuilder;
import dev.bluesheep.nanomirai.recipe.synthesize.SynthesizeRecipe;
import dev.bluesheep.nanomirai.util.NanoTier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Ldev/bluesheep/nanomirai/recipe/synthesize/SynthesizeRecipeBuilder;", "Ldev/bluesheep/nanomirai/recipe/SimpleRecipeBuilder;", "result", "Lnet/minecraft/world/item/ItemStack;", "tier", "Ldev/bluesheep/nanomirai/util/NanoTier;", "block", "Lnet/minecraft/world/level/block/state/BlockState;", "catalyst", "Lnet/minecraft/world/item/crafting/Ingredient;", "duration", "", "<init>", "(Lnet/minecraft/world/item/ItemStack;Ldev/bluesheep/nanomirai/util/NanoTier;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/item/crafting/Ingredient;I)V", "getTier", "()Ldev/bluesheep/nanomirai/util/NanoTier;", "getBlock", "()Lnet/minecraft/world/level/block/state/BlockState;", "getCatalyst", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getDuration", "()I", "save", "", "output", "Lnet/minecraft/data/recipes/RecipeOutput;", "id", "Lnet/minecraft/resources/ResourceLocation;", "nanomirai"})
public final class SynthesizeRecipeBuilder
extends SimpleRecipeBuilder {
    @NotNull
    private final NanoTier tier;
    @NotNull
    private final BlockState block;
    @NotNull
    private final Ingredient catalyst;
    private final int duration;

    public SynthesizeRecipeBuilder(@NotNull ItemStack result, @NotNull NanoTier tier, @NotNull BlockState block, @NotNull Ingredient catalyst, int duration) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)((Object)tier), (String)"tier");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)catalyst, (String)"catalyst");
        super(result);
        this.tier = tier;
        this.block = block;
        this.catalyst = catalyst;
        this.duration = duration;
    }

    @NotNull
    public final NanoTier getTier() {
        return this.tier;
    }

    @NotNull
    public final BlockState getBlock() {
        return this.block;
    }

    @NotNull
    public final Ingredient getCatalyst() {
        return this.catalyst;
    }

    public final int getDuration() {
        return this.duration;
    }

    public void save(@NotNull RecipeOutput output, @NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResourceLocation recipeId = id.withPrefix("synthesize/");
        SynthesizeRecipe recipe = new SynthesizeRecipe(this.getResult(), this.tier.getRarity().ordinal(), this.block, this.catalyst, this.duration);
        output.accept(recipeId, (Recipe)recipe, null);
    }
}

