/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ghastcow.client.model;

import java.util.Random;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class GhastCowModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart[] tentacles = new ModelPart[9];

    public GhastCowModel(ModelPart part) {
        this.root = part;
        this.head = part.getChild("head");
        this.body = part.getChild("body");
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i] = part.getChild(GhastCowModel.createTentacleName(i));
        }
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 4).addBox(-6.0f, -10.0f, -20.0f, 12.0f, 18.0f, 10.0f).texOffs(52, 0).addBox(-2.0f, 2.0f, -21.0f, 4.0f, 6.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 9.0f, -6.0f, 8.0f, 8.0f, 6.0f).texOffs(22, 0).addBox(4.0f, 8.0f, -4.0f, 1.0f, 3.0f, 1.0f).texOffs(22, 0).addBox(-5.0f, 8.0f, -4.0f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)-8.0f));
        Random random = new Random(1660L);
        for (int i = 0; i < 9; ++i) {
            float f = (((float)(i % 3) - (float)(i / 3 % 2) * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
            float f1 = ((float)(i / 3) / 2.0f * 2.0f - 1.0f) * 5.0f;
            int j = random.nextInt(7) + 8;
            partdefinition.addOrReplaceChild(GhastCowModel.createTentacleName(i), CubeListBuilder.create().texOffs(2, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, (float)j, 2.0f), PartPose.offset((float)f, (float)24.6f, (float)f1));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static String createTentacleName(int i) {
        return "tentacle" + i;
    }

    private static void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].xRot = 0.2f * Mth.sin((float)(ageInTicks * 0.3f + (float)i)) + 0.4f;
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

