/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ghastcow.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.ghastcow.client.ClientClass;
import com.mrbysco.ghastcow.client.model.GhastCowModel;
import com.mrbysco.ghastcow.client.renderer.GhastCowAuraLayer;
import com.mrbysco.ghastcow.entity.GhastCow;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class GhastCowRenderer
extends MobRenderer<GhastCow, GhastCowModel<GhastCow>> {
    private static final ResourceLocation INVULNERABLE_GHASTCOW_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"ghastcow", (String)"textures/entity/ghastcow_invulnerable.png");
    private static final ResourceLocation GHASTCOW_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"ghastcow", (String)"textures/entity/ghastcow.png");
    private static final ResourceLocation GHASTCOW_SHOOTING_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"ghastcow", (String)"textures/entity/ghastcow_shooting.png");

    public GhastCowRenderer(EntityRendererProvider.Context context) {
        super(context, new GhastCowModel(context.bakeLayer(ClientClass.GHAST_COW)), 1.5f);
        this.addLayer((RenderLayer)new GhastCowAuraLayer((RenderLayerParent<GhastCow, GhastCowModel<GhastCow>>)this, context.getModelSet()));
    }

    protected int getBlockLightLevel(GhastCow entityIn, BlockPos pos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(GhastCow ghastCow) {
        int i = ghastCow.getInvulnerableTicks();
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? INVULNERABLE_GHASTCOW_TEXTURES : (ghastCow.isAttacking() ? GHASTCOW_SHOOTING_TEXTURES : GHASTCOW_TEXTURES);
    }

    protected void scale(GhastCow ghastCowEntity, PoseStack matrixStackIn, float partialTickTime) {
        float f = 2.5f;
        int i = ghastCowEntity.getInvulnerableTicks();
        if (i > 0) {
            f -= ((float)i - partialTickTime) / 220.0f * 0.5f;
        }
        matrixStackIn.scale(f, f, f);
    }
}

