/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ghastcow.entity;

import com.mrbysco.ghastcow.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class FlyingMonster
extends Monster {
    protected FlyingMonster(EntityType<? extends FlyingMonster> type, Level level) {
        super(type, level);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void travel(Vec3 travelVector) {
        if (this.isInWater()) {
            this.moveRelative(0.02f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
        } else if (this.isInLava()) {
            this.moveRelative(0.02f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        } else {
            BlockPos ground = BlockPos.containing((double)this.getX(), (double)(this.getY() - 1.0), (double)this.getZ());
            float f = 0.91f;
            if (this.onGround()) {
                f = Services.PLATFORM.getBlockFriction(this.level(), ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.onGround()) {
                f = Services.PLATFORM.getBlockFriction(this.level(), ground, (Entity)this) * 0.91f;
            }
            this.moveRelative(this.onGround() ? 0.1f * f1 : 0.02f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)f));
        }
        this.calculateEntityAnimation(false);
    }

    public boolean onClimbable() {
        return false;
    }
}

