/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ghastcow;

import com.mrbysco.ghastcow.entity.GhastCow;
import com.mrbysco.ghastcow.platform.Services;
import com.mrbysco.ghastcow.registration.ModEntities;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;

public class CommonClass {
    public static void init() {
        ModEntities.loadClass();
    }

    public static void onDeath(LivingEntity livingEntity, DamageSource source) {
        LargeFireball fireball;
        Entity directEntity;
        Level level = livingEntity.level();
        if (!level.isClientSide && (directEntity = source.getDirectEntity()) instanceof LargeFireball && (fireball = (LargeFireball)directEntity).getOwner() instanceof Ghast && livingEntity instanceof Cow) {
            Cow cowEntity = (Cow)livingEntity;
            if (!Services.PLATFORM.requiresName() || cowEntity.hasCustomName() && cowEntity.getCustomName() != null && cowEntity.getCustomName().getString().toLowerCase(Locale.ROOT).equals("ghast")) {
                BlockPos blockpos = cowEntity.blockPosition();
                GhastCow ghastCow = (GhastCow)ModEntities.GHAST_COW.get().create(level, EntitySpawnReason.MOB_SUMMONED);
                if (ghastCow != null) {
                    ghastCow.moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 1.55, (double)blockpos.getZ() + 0.5, cowEntity.getYRot(), cowEntity.getXRot());
                    ghastCow.yBodyRot = cowEntity.yBodyRot;
                    level.addFreshEntity((Entity)ghastCow);
                }
            }
        }
    }
}

