/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ghastcow.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.ghastcow.Constants;
import com.mrbysco.ghastcow.client.ClientClass;
import com.mrbysco.ghastcow.client.GhastCowRenderState;
import com.mrbysco.ghastcow.client.model.GhastCowModel;
import com.mrbysco.ghastcow.client.renderer.GhastCowAuraLayer;
import com.mrbysco.ghastcow.entity.GhastCow;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class GhastCowRenderer
extends MobRenderer<GhastCow, GhastCowRenderState, GhastCowModel> {
    private static final ResourceLocation INVULNERABLE_GHASTCOW_TEXTURES = Constants.modLoc("textures/entity/ghastcow_invulnerable.png");
    private static final ResourceLocation GHASTCOW_TEXTURES = Constants.modLoc("textures/entity/ghastcow.png");
    private static final ResourceLocation GHASTCOW_SHOOTING_TEXTURES = Constants.modLoc("textures/entity/ghastcow_shooting.png");

    public GhastCowRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GhastCowModel(context.bakeLayer(ClientClass.GHAST_COW)), 1.5f);
        this.addLayer((RenderLayer)new GhastCowAuraLayer((RenderLayerParent<GhastCowRenderState, GhastCowModel>)this, context.getModelSet()));
    }

    protected int getBlockLightLevel(GhastCow entityIn, BlockPos pos) {
        return 15;
    }

    public GhastCowRenderState createRenderState() {
        return new GhastCowRenderState();
    }

    public void extractRenderState(GhastCow ghastCow, GhastCowRenderState renderState, float partialTicks) {
        super.extractRenderState((LivingEntity)ghastCow, (LivingEntityRenderState)renderState, partialTicks);
        int i = ghastCow.getInvulnerableTicks();
        renderState.invulnerableTicks = i > 0 ? (float)i - partialTicks : 0.0f;
        renderState.isPowered = ghastCow.isPowered();
        renderState.isAttacking = ghastCow.isAttacking();
    }

    public ResourceLocation getTextureLocation(GhastCowRenderState renderState) {
        int i = Mth.floor((float)renderState.invulnerableTicks);
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? INVULNERABLE_GHASTCOW_TEXTURES : (renderState.isAttacking ? GHASTCOW_SHOOTING_TEXTURES : GHASTCOW_TEXTURES);
    }

    protected void scale(GhastCowRenderState renderState, PoseStack poseStack) {
        float f = 2.0f;
        if (renderState.invulnerableTicks > 0.0f) {
            f -= renderState.invulnerableTicks / 220.0f * 0.5f;
        }
        poseStack.scale(f, f, f);
    }
}

