/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ghastcow.entity;

import com.mrbysco.ghastcow.entity.FlyingMonster;
import com.mrbysco.ghastcow.platform.Services;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GhastCow
extends FlyingMonster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(GhastCow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> INVULNERABILITY_TIME = SynchedEntityData.defineId(GhastCow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.defineId(GhastCow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int nextUpdate = 0;
    private int idleUpdate = 0;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).setCreateWorldFog(true);
    private static final TargetingConditions.Selector NOT_UNDEAD = (livingEntity, serverLevel) -> !livingEntity.getType().is(EntityTypeTags.UNDEAD) && !(livingEntity instanceof Cow) && livingEntity.attackable();
    private static final TargetingConditions ENEMY_CONDITION = TargetingConditions.forCombat().range(20.0).selector(NOT_UNDEAD);

    public GhastCow(EntityType<? extends FlyingMonster> type, Level level) {
        super(type, level);
        this.setHealth(this.getMaxHealth());
        this.getNavigation().setCanFloat(true);
        this.xpReward = 50;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new DoNothingGoal());
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 0, false, false, NOT_UNDEAD));
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, (double)0.6f).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ARMOR, 4.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACKING, (Object)false);
        builder.define(TARGET, (Object)0);
        builder.define(INVULNERABILITY_TIME, (Object)0);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public int getInvulnerableTicks() {
        return (Integer)this.entityData.get(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.entityData.set(INVULNERABILITY_TIME, (Object)time);
    }

    public int getTargetID() {
        return (Integer)this.entityData.get(TARGET);
    }

    public void updateTargetID(int newId) {
        this.entityData.set(TARGET, (Object)newId);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setInvulTime(compound.getInt("Invul"));
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    public void aiStep() {
        Entity entity;
        Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.6, 1.0);
        if (!this.level().isClientSide && this.getTargetID() > 0 && (entity = this.level().getEntity(this.getTargetID())) != null) {
            double d0 = vec3.y;
            if (this.getY() < entity.getY() || !this.isPowered() && this.getY() < entity.getY() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3 = new Vec3(vec3.x, d0, vec3.z);
            Vec3 vec31 = new Vec3(entity.getX() - this.getX(), 0.0, entity.getZ() - this.getZ());
            if (vec31.horizontalDistanceSqr() > 9.0) {
                Vec3 vec32 = vec31.normalize();
                vec3 = vec3.add(vec32.x * 0.3 - vec3.x * 0.6, 0.0, vec32.z * 0.3 - vec3.z * 0.6);
            }
        }
        this.setDeltaMovement(vec3);
        if (vec3.horizontalDistanceSqr() > 0.05) {
            this.setYRot((float)Mth.atan2((double)vec3.z, (double)vec3.x) * 57.295776f - 90.0f);
        }
        super.aiStep();
        boolean flag = this.isPowered();
        double d8 = this.getX();
        double d10 = this.getY();
        double d2 = this.getZ();
        this.level().addParticle((ParticleOptions)ParticleTypes.POOF, d8 + this.random.nextGaussian() * (double)0.3f, d10 + this.random.nextGaussian() * (double)0.3f, d2 + this.random.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
        if (flag && this.level().random.nextInt(4) == 0) {
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.7f, (float)0.7f, (float)0.5f), d8 + this.random.nextGaussian() * (double)0.3f, d10 + this.random.nextGaussian() * (double)0.3f, d2 + this.random.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
        }
        if (this.getInvulnerableTicks() > 0) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.7f, (float)0.7f, (float)0.9f), this.getX() + this.random.nextGaussian(), this.getY() + (double)(this.random.nextFloat() * 3.3f), this.getZ() + this.random.nextGaussian(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void customServerAiStep(ServerLevel level) {
        if (this.getInvulnerableTicks() > 0) {
            int j1 = this.getInvulnerableTicks() - 1;
            if (j1 <= 0) {
                Level.ExplosionInteraction explosion$mode = Services.PLATFORM.cancelMobGriefing(level, (Entity)this) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
                level.explode((Entity)this, this.getX(), this.getEyeY(), this.getZ(), 7.0f, false, explosion$mode);
                if (!this.isSilent()) {
                    level.playSound(null, this.blockPosition(), SoundEvents.GHAST_SCREAM, this.getSoundCategory(), this.getSoundVolume(), 1.0f);
                }
            }
            this.setInvulTime(j1);
            if (this.tickCount % 10 == 0) {
                this.heal(10.0f);
            }
        } else {
            super.customServerAiStep(level);
            if (this.tickCount >= this.nextUpdate) {
                int targetID;
                int idleHeadUpdates;
                this.nextUpdate = this.tickCount + 10 + this.random.nextInt(10);
                if ((level.getDifficulty() == Difficulty.NORMAL || level.getDifficulty() == Difficulty.HARD) && (idleHeadUpdates = this.idleUpdate++) > 15) {
                    float f = 10.0f;
                    float f1 = 5.0f;
                    double d0 = Mth.nextDouble((RandomSource)this.random, (double)(this.getX() - (double)f), (double)(this.getX() + (double)f));
                    double d1 = Mth.nextDouble((RandomSource)this.random, (double)(this.getY() - (double)f1), (double)(this.getY() + (double)f1));
                    double d2 = Mth.nextDouble((RandomSource)this.random, (double)(this.getZ() - (double)f), (double)(this.getZ() + (double)f));
                    this.launchFireballToCoords(d0, d1, d2, true);
                    this.idleUpdate = 0;
                }
                if ((targetID = this.getTargetID()) > 0) {
                    Entity entity = level.getEntity(targetID);
                    if (entity != null && entity.isAlive() && !(this.distanceToSqr(entity) > 900.0) && this.hasLineOfSight(entity)) {
                        if (entity instanceof Player && ((Player)entity).getAbilities().invulnerable) {
                            this.updateTargetID(0);
                        } else {
                            this.launchFireball((LivingEntity)entity);
                            this.nextUpdate = this.tickCount + 40 + this.random.nextInt(20);
                            this.idleUpdate = 0;
                        }
                    } else {
                        this.updateTargetID(0);
                    }
                } else {
                    List list = level.getNearbyEntities(LivingEntity.class, ENEMY_CONDITION, (LivingEntity)this, this.getBoundingBox().inflate(20.0, 8.0, 20.0));
                    for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                        LivingEntity livingentity = (LivingEntity)list.get(this.random.nextInt(list.size()));
                        if (livingentity != this && livingentity.isAlive() && this.hasLineOfSight((Entity)livingentity)) {
                            if (livingentity instanceof Player) {
                                if (((Player)livingentity).getAbilities().invulnerable) break;
                                this.updateTargetID(livingentity.getId());
                                break;
                            }
                            this.updateTargetID(livingentity.getId());
                            break;
                        }
                        list.remove(livingentity);
                    }
                }
            }
            if (this.getTarget() != null) {
                this.updateTargetID(this.getTarget().getId());
            } else {
                this.updateTargetID(0);
            }
            if (this.tickCount % 60 == 0) {
                this.heal(1.0f);
            }
            this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public SoundSource getSoundCategory() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.COW_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.COW_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COW_DEATH;
    }

    protected float getSoundVolume() {
        return 5.0f;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean canUsePortal(boolean allowPassengers) {
        return false;
    }

    public static boolean canSpawnHere(EntityType<GhastCow> entityType, LevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        return world.getDifficulty() != Difficulty.PEACEFUL && random.nextInt(20) == 0 && GhastCow.checkMobSpawnRules(entityType, (LevelAccessor)world, (EntitySpawnReason)reason, (BlockPos)pos, (RandomSource)random);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        this.launchFireball(target);
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        if (this.isInvulnerableTo(level, source)) {
            return false;
        }
        if (!source.is(DamageTypeTags.WITHER_IMMUNE_TO) && !(source.getEntity() instanceof WitherBoss)) {
            Entity entity;
            if (this.getInvulnerableTicks() > 0 && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                return false;
            }
            if (this.isPowered() && ((entity = source.getDirectEntity()) instanceof AbstractArrow || entity instanceof WindCharge)) {
                return false;
            }
            Entity entity1 = source.getEntity();
            if (entity1 != null && entity1.getType().is(EntityTypeTags.WITHER_FRIENDS)) {
                return false;
            }
            this.idleUpdate += 3;
            return super.hurtServer(level, source, amount);
        }
        return false;
    }

    private void launchFireball(LivingEntity target) {
        this.launchFireballToCoords(target.getX(), target.getY() + (double)target.getEyeHeight() * 0.5, target.getZ(), this.random.nextFloat() < 0.001f);
    }

    private void launchFireballToCoords(double x, double y, double z, boolean invulnerable) {
        this.setAttacking(true);
        if (!this.isSilent()) {
            this.level().levelEvent((Player)null, 1024, this.blockPosition(), 0);
        }
        double d1 = x - this.getX();
        double d2 = y - this.getY();
        double d3 = z - this.getZ();
        Vec3 vec3 = new Vec3(d1, d2, d3);
        LargeFireball fireball = new LargeFireball(this.level(), (LivingEntity)this, vec3, 1);
        fireball.setOwner((Entity)this);
        fireball.setPos(this.getX() + vec3.x * 4.0, this.getY(0.5) + 0.5, fireball.getZ() + vec3.z * 4.0);
        this.level().addFreshEntity((Entity)fireball);
        this.setAttacking(false);
    }

    public boolean isPowered() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyIn, EntitySpawnReason reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setInvulTime(220);
        this.setHealth(this.getMaxHealth() / 2.0f);
        return super.finalizeSpawn(levelAccessor, difficultyIn, reason, spawnDataIn);
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return GhastCow.this.getInvulnerableTicks() > 0;
        }
    }
}

