/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.itemresistance;

import dev.apexstudios.itemresistance.mixin.ServerExplosionAccessor;
import dev.apexstudios.registree.api.Registree;
import dev.apexstudios.registree.api.holder.DeferredGameRule;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleCategory;
import net.minecraft.world.level.gamerules.GameRules;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ExplosionEvent;

@Mod(value="itemresistance")
public final class ItemResistance {
    public static final String ID = "itemresistance";
    public static final Registree REGISTREE = Registree.create((String)"itemresistance");
    public static final DeferredGameRule<Boolean> ALLOW_EXPLOSION = REGISTREE.registerBooleanGameRule("allow_explosions", GameRuleCategory.MISC, true);

    public ItemResistance(IEventBus modBus) {
        REGISTREE.registerEvents(modBus);
        NeoForge.EVENT_BUS.addListener(ExplosionEvent.Start.class, event -> {
            ServerLevel level = (ServerLevel)event.getLevel();
            GameRules gameRules = level.getGameRules();
            if (!((Boolean)gameRules.get((GameRule)ALLOW_EXPLOSION.value())).booleanValue()) {
                event.setCanceled(true);
            }
        });
    }

    public static boolean shouldExplode(BlockPos pos, ItemStack stack, ServerExplosion explosion) {
        ServerLevel level = explosion.level();
        Block block = Block.byItem((Item)stack.getItem());
        ExplosionDamageCalculator calculator = ((ServerExplosionAccessor)explosion).getDamageCalculator();
        BlockItemStateProperties blockStateProperties = (BlockItemStateProperties)stack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
        BlockState blockState = blockStateProperties.isEmpty() ? block.defaultBlockState() : blockStateProperties.apply(block.defaultBlockState());
        for (float power = explosion.radius() * (0.7f + level.random.nextFloat() * 0.6f); power > 0.0f; power -= 0.22500001f) {
            Optional resistance = calculator.getBlockExplosionResistance((Explosion)explosion, (BlockGetter)level, pos, blockState, level.getFluidState(pos));
            if (resistance.isPresent()) {
                power -= (((Float)resistance.get()).floatValue() + 0.3f) * 0.3f;
            }
            if (!(power > 0.0f) || !calculator.shouldBlockExplode((Explosion)explosion, (BlockGetter)level, pos, blockState, power)) continue;
            return true;
        }
        return false;
    }
}

