/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.itemresistance.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.apexstudios.itemresistance.ItemResistance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ServerExplosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Shadow
    public abstract ItemStack getItem();

    @ModifyReturnValue(method={"ignoreExplosion"}, at={@At(value="RETURN")})
    private boolean ignoreExplosion(boolean original, @Local(argsOnly=true) Explosion explosion) {
        ItemEntity self = (ItemEntity)ItemEntity.class.cast(this);
        if (explosion instanceof ServerExplosion) {
            ServerExplosion sExplosion = (ServerExplosion)explosion;
            if (!ItemResistance.shouldExplode(self.blockPosition(), this.getItem(), sExplosion)) {
                return true;
            }
        }
        return original;
    }
}

