/*
 * Decompiled with CFR 0.152.
 */
package io.nayuki.flac;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class BitInputStream
implements AutoCloseable {
    private InputStream in;
    private long bitBuffer;
    private int bitBufferLen;

    public BitInputStream(InputStream in) {
        this.in = in;
    }

    public void alignToByte() {
        this.bitBufferLen -= this.bitBufferLen % 8;
    }

    public int readByte() throws IOException {
        if (this.bitBufferLen >= 8) {
            return this.readUint(8);
        }
        return this.in.read();
    }

    public int readUint(int n) throws IOException {
        while (this.bitBufferLen < n) {
            int temp = this.in.read();
            if (temp == -1) {
                throw new EOFException();
            }
            this.bitBuffer = this.bitBuffer << 8 | (long)temp;
            this.bitBufferLen += 8;
        }
        this.bitBufferLen -= n;
        int result = (int)(this.bitBuffer >>> this.bitBufferLen);
        if (n < 32) {
            result &= (1 << n) - 1;
        }
        return result;
    }

    public int readSignedInt(int n) throws IOException {
        return this.readUint(n) << 32 - n >> 32 - n;
    }

    public long readRiceSignedInt(int param) throws IOException {
        long val = 0L;
        while (this.readUint(1) == 0) {
            ++val;
        }
        val = val << param | (long)this.readUint(param);
        return val >>> 1 ^ -(val & 1L);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

