/*
 * Decompiled with CFR 0.152.
 */
package io.nayuki.flac;

import io.nayuki.flac.BitInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.DataFormatException;

public final class SimpleDecodeFlacToWav {
    private static final int[][] FIXED_PREDICTION_COEFFICIENTS = new int[][]{new int[0], {1}, {2, -1}, {3, -3, 1}, {4, -6, 4, -1}};

    public static void main(String[] args) throws IOException, DataFormatException {
        if (args.length != 2) {
            System.err.println("Usage: java SimpleDecodeFlacToWav InFile.flac OutFile.wav");
            System.exit(1);
            return;
        }
        try (BitInputStream in = new BitInputStream(new BufferedInputStream(new FileInputStream(args[0])));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(args[1]));){
            SimpleDecodeFlacToWav.decodeFile(in, out);
        }
    }

    public static void decodeFile(BitInputStream in, OutputStream out) throws IOException, DataFormatException {
        if (in.readUint(32) != 1716281667) {
            throw new DataFormatException("Invalid magic string");
        }
        int sampleRate = -1;
        int numChannels = -1;
        int sampleDepth = -1;
        long numSamples = -1L;
        boolean last = false;
        while (!last) {
            int i;
            last = in.readUint(1) != 0;
            int type = in.readUint(7);
            int length = in.readUint(24);
            if (type == 0) {
                in.readUint(16);
                in.readUint(16);
                in.readUint(24);
                in.readUint(24);
                sampleRate = in.readUint(20);
                numChannels = in.readUint(3) + 1;
                sampleDepth = in.readUint(5) + 1;
                numSamples = (long)in.readUint(18) << 18 | (long)in.readUint(18);
                for (i = 0; i < 16; ++i) {
                    in.readUint(8);
                }
                continue;
            }
            for (i = 0; i < length; ++i) {
                in.readUint(8);
            }
        }
        if (sampleRate == -1) {
            throw new DataFormatException("Stream info metadata block absent");
        }
        if (sampleDepth % 8 != 0) {
            throw new RuntimeException("Sample depth not supported");
        }
        long sampleDataLen = numSamples * (long)numChannels * (long)(sampleDepth / 8);
        SimpleDecodeFlacToWav.writeString("RIFF", out);
        SimpleDecodeFlacToWav.writeLittleInt(4, (int)sampleDataLen + 36, out);
        SimpleDecodeFlacToWav.writeString("WAVE", out);
        SimpleDecodeFlacToWav.writeString("fmt ", out);
        SimpleDecodeFlacToWav.writeLittleInt(4, 16, out);
        SimpleDecodeFlacToWav.writeLittleInt(2, 1, out);
        SimpleDecodeFlacToWav.writeLittleInt(2, numChannels, out);
        SimpleDecodeFlacToWav.writeLittleInt(4, sampleRate, out);
        SimpleDecodeFlacToWav.writeLittleInt(4, sampleRate * numChannels * (sampleDepth / 8), out);
        SimpleDecodeFlacToWav.writeLittleInt(2, numChannels * (sampleDepth / 8), out);
        SimpleDecodeFlacToWav.writeLittleInt(2, sampleDepth, out);
        SimpleDecodeFlacToWav.writeString("data", out);
        SimpleDecodeFlacToWav.writeLittleInt(4, (int)sampleDataLen, out);
        while (SimpleDecodeFlacToWav.decodeFrame(in, numChannels, sampleDepth, out)) {
        }
    }

    private static void writeLittleInt(int numBytes, int val, OutputStream out) throws IOException {
        for (int i = 0; i < numBytes; ++i) {
            out.write(val >>> i * 8);
        }
    }

    private static void writeString(String s, OutputStream out) throws IOException {
        out.write(s.getBytes(StandardCharsets.UTF_8));
    }

    private static boolean decodeFrame(BitInputStream in, int numChannels, int sampleDepth, OutputStream out) throws IOException, DataFormatException {
        int blockSize;
        int temp = in.readByte();
        if (temp == -1) {
            return false;
        }
        int sync = temp << 6 | in.readUint(6);
        if (sync != 16382) {
            throw new DataFormatException("Sync code expected");
        }
        in.readUint(1);
        in.readUint(1);
        int blockSizeCode = in.readUint(4);
        int sampleRateCode = in.readUint(4);
        int chanAsgn = in.readUint(4);
        in.readUint(3);
        in.readUint(1);
        temp = Integer.numberOfLeadingZeros(~(in.readUint(8) << 24)) - 1;
        for (int i = 0; i < temp; ++i) {
            in.readUint(8);
        }
        if (blockSizeCode == 1) {
            blockSize = 192;
        } else if (2 <= blockSizeCode && blockSizeCode <= 5) {
            blockSize = 576 << blockSizeCode - 2;
        } else if (blockSizeCode == 6) {
            blockSize = in.readUint(8) + 1;
        } else if (blockSizeCode == 7) {
            blockSize = in.readUint(16) + 1;
        } else if (8 <= blockSizeCode && blockSizeCode <= 15) {
            blockSize = 256 << blockSizeCode - 8;
        } else {
            throw new DataFormatException("Reserved block size");
        }
        if (sampleRateCode == 12) {
            in.readUint(8);
        } else if (sampleRateCode == 13 || sampleRateCode == 14) {
            in.readUint(16);
        }
        in.readUint(8);
        int[][] samples = new int[numChannels][blockSize];
        SimpleDecodeFlacToWav.decodeSubframes(in, sampleDepth, chanAsgn, samples);
        in.alignToByte();
        in.readUint(16);
        for (int i = 0; i < blockSize; ++i) {
            for (int j = 0; j < numChannels; ++j) {
                int val = samples[j][i];
                if (sampleDepth == 8) {
                    val += 128;
                }
                SimpleDecodeFlacToWav.writeLittleInt(sampleDepth / 8, val, out);
            }
        }
        return true;
    }

    private static void decodeSubframes(BitInputStream in, int sampleDepth, int chanAsgn, int[][] result) throws IOException, DataFormatException {
        int ch;
        int blockSize = result[0].length;
        long[][] subframes = new long[result.length][blockSize];
        if (0 <= chanAsgn && chanAsgn <= 7) {
            for (ch = 0; ch < result.length; ++ch) {
                SimpleDecodeFlacToWav.decodeSubframe(in, sampleDepth, subframes[ch]);
            }
        } else if (8 <= chanAsgn && chanAsgn <= 10) {
            SimpleDecodeFlacToWav.decodeSubframe(in, sampleDepth + (chanAsgn == 9 ? 1 : 0), subframes[0]);
            SimpleDecodeFlacToWav.decodeSubframe(in, sampleDepth + (chanAsgn == 9 ? 0 : 1), subframes[1]);
            if (chanAsgn == 8) {
                for (i = 0; i < blockSize; ++i) {
                    subframes[1][i] = subframes[0][i] - subframes[1][i];
                }
            } else if (chanAsgn == 9) {
                for (i = 0; i < blockSize; ++i) {
                    long[] lArray = subframes[0];
                    int n = i;
                    lArray[n] = lArray[n] + subframes[1][i];
                }
            } else if (chanAsgn == 10) {
                for (i = 0; i < blockSize; ++i) {
                    long right;
                    long side = subframes[1][i];
                    subframes[1][i] = right = subframes[0][i] - (side >> 1);
                    subframes[0][i] = right + side;
                }
            }
        } else {
            throw new DataFormatException("Reserved channel assignment");
        }
        for (ch = 0; ch < result.length; ++ch) {
            for (int i = 0; i < blockSize; ++i) {
                result[ch][i] = (int)subframes[ch][i];
            }
        }
    }

    private static void decodeSubframe(BitInputStream in, int sampleDepth, long[] result) throws IOException, DataFormatException {
        int i;
        in.readUint(1);
        int type = in.readUint(6);
        int shift = in.readUint(1);
        if (shift == 1) {
            while (in.readUint(1) == 0) {
                ++shift;
            }
        }
        sampleDepth -= shift;
        if (type == 0) {
            Arrays.fill(result, 0, result.length, (long)in.readSignedInt(sampleDepth));
        } else if (type == 1) {
            for (i = 0; i < result.length; ++i) {
                result[i] = in.readSignedInt(sampleDepth);
            }
        } else if (8 <= type && type <= 12) {
            SimpleDecodeFlacToWav.decodeFixedPredictionSubframe(in, type - 8, sampleDepth, result);
        } else if (32 <= type && type <= 63) {
            SimpleDecodeFlacToWav.decodeLinearPredictiveCodingSubframe(in, type - 31, sampleDepth, result);
        } else {
            throw new DataFormatException("Reserved subframe type");
        }
        i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] << shift;
        }
    }

    private static void decodeFixedPredictionSubframe(BitInputStream in, int predOrder, int sampleDepth, long[] result) throws IOException, DataFormatException {
        for (int i = 0; i < predOrder; ++i) {
            result[i] = in.readSignedInt(sampleDepth);
        }
        SimpleDecodeFlacToWav.decodeResiduals(in, predOrder, result);
        SimpleDecodeFlacToWav.restoreLinearPrediction(result, FIXED_PREDICTION_COEFFICIENTS[predOrder], 0);
    }

    private static void decodeLinearPredictiveCodingSubframe(BitInputStream in, int lpcOrder, int sampleDepth, long[] result) throws IOException, DataFormatException {
        for (int i = 0; i < lpcOrder; ++i) {
            result[i] = in.readSignedInt(sampleDepth);
        }
        int precision = in.readUint(4) + 1;
        int shift = in.readSignedInt(5);
        int[] coefs = new int[lpcOrder];
        for (int i = 0; i < coefs.length; ++i) {
            coefs[i] = in.readSignedInt(precision);
        }
        SimpleDecodeFlacToWav.decodeResiduals(in, lpcOrder, result);
        SimpleDecodeFlacToWav.restoreLinearPrediction(result, coefs, shift);
    }

    private static void decodeResiduals(BitInputStream in, int warmup, long[] result) throws IOException, DataFormatException {
        int method = in.readUint(2);
        if (method >= 2) {
            throw new DataFormatException("Reserved residual coding method");
        }
        int paramBits = method == 0 ? 4 : 5;
        int escapeParam = method == 0 ? 15 : 31;
        int partitionOrder = in.readUint(4);
        int numPartitions = 1 << partitionOrder;
        if (result.length % numPartitions != 0) {
            throw new DataFormatException("Block size not divisible by number of Rice partitions");
        }
        int partitionSize = result.length / numPartitions;
        for (int i = 0; i < numPartitions; ++i) {
            int start = i * partitionSize + (i == 0 ? warmup : 0);
            int end = (i + 1) * partitionSize;
            int param = in.readUint(paramBits);
            if (param < escapeParam) {
                for (int j = start; j < end; ++j) {
                    result[j] = in.readRiceSignedInt(param);
                }
                continue;
            }
            int numBits = in.readUint(5);
            for (int j = start; j < end; ++j) {
                result[j] = in.readSignedInt(numBits);
            }
        }
    }

    private static void restoreLinearPrediction(long[] result, int[] coefs, int shift) {
        int i = coefs.length;
        while (i < result.length) {
            long sum = 0L;
            for (int j = 0; j < coefs.length; ++j) {
                sum += result[i - 1 - j] * (long)coefs[j];
            }
            int n = i++;
            result[n] = result[n] + (sum >> shift);
        }
    }
}

