/*
 * Decompiled with CFR 0.152.
 */
package org.nullversionnova.musicscript.sound;

import io.nayuki.flac.SimpleDecodeFlacToWav;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javazoom.jl.converter.Converter;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.nullversionnova.musicscript.MusicScript;
import org.nullversionnova.musicscript.sound.RawSoundEngine;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0007J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\f\u0010\u0007J\u000f\u0010\r\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\r\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/nullversionnova/musicscript/sound/ExternalSoundManager;", "", "", "isAnythingPlaying", "()Z", "", "pause", "()V", "Ljava/io/File;", "sound", "playSound", "(Ljava/io/File;)Z", "resume", "stopSounds", "<init>", "musicscript"})
public final class ExternalSoundManager {
    @NotNull
    public static final ExternalSoundManager INSTANCE = new ExternalSoundManager();

    private ExternalSoundManager() {
    }

    @JvmStatic
    public static final boolean playSound(@NotNull File sound) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        return switch (FilesKt.getExtension((File)sound)) {
            case "au", "aiff", "wav" -> RawSoundEngine.start$default(sound, null, 2, null);
            case "flac" -> {
                new File(MusicScript.INSTANCE.getDATA_PATH() + "/temp/flac").mkdirs();
                File dummyfile = new File(MusicScript.INSTANCE.getDATA_PATH() + "/temp/flac/" + FilesKt.getNameWithoutExtension((File)sound) + ".wav");
                if (dummyfile.createNewFile()) {
                    String[] var3_4 = new String[]{sound.getAbsolutePath(), dummyfile.getAbsolutePath()};
                    SimpleDecodeFlacToWav.main(var3_4);
                }
                dummyfile.deleteOnExit();
                yield RawSoundEngine.start(sound, new BufferedInputStream(new FileInputStream(dummyfile)));
            }
            case "mp3" -> {
                Converter converter = new Converter();
                new File(MusicScript.INSTANCE.getDATA_PATH() + "/temp/mp3").mkdirs();
                File dummyfile = new File(MusicScript.INSTANCE.getDATA_PATH() + "/temp/mp3/" + FilesKt.getNameWithoutExtension((File)sound) + ".wav");
                if (dummyfile.createNewFile()) {
                    converter.convert(sound.getAbsolutePath(), dummyfile.getAbsolutePath());
                }
                dummyfile.deleteOnExit();
                yield RawSoundEngine.start(sound, new BufferedInputStream(new FileInputStream(dummyfile)));
            }
            case "ogg" -> false;
            default -> false;
        };
    }

    @JvmStatic
    public static final void stopSounds() {
        RawSoundEngine.stopSounds();
    }

    @JvmStatic
    public static final void pause() {
        RawSoundEngine.INSTANCE.pause();
    }

    @JvmStatic
    public static final void resume() {
        RawSoundEngine.INSTANCE.resume();
    }

    @JvmStatic
    public static final boolean isAnythingPlaying() {
        return RawSoundEngine.INSTANCE.isAnythingPlaying();
    }
}

