/*
 * Decompiled with CFR 0.152.
 */
package org.nullversionnova.musicscript.sound;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b$\u0010\u0007J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001c0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001f0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001eR\u0016\u0010!\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010\n\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010#\u00a8\u0006%"}, d2={"Lorg/nullversionnova/musicscript/sound/RawSoundEngine;", "", "", "isAnythingPlaying", "()Z", "", "pause", "()V", "resume", "", "volume", "setVolume", "(F)V", "Ljava/io/File;", "file", "Ljava/io/InputStream;", "stream", "start", "(Ljava/io/File;Ljava/io/InputStream;)Z", "sound", "stopSound", "(Ljava/io/File;)V", "stopSounds", "", "MaxGain", "I", "MinGain", "", "Ljavax/sound/sampled/FloatControl;", "gains", "Ljava/util/Map;", "Ljavax/sound/sampled/Clip;", "loadedSounds", "paused", "Z", "F", "<init>", "musicscript"})
public final class RawSoundEngine {
    @NotNull
    public static final RawSoundEngine INSTANCE = new RawSoundEngine();
    @NotNull
    private static final Map<File, Clip> loadedSounds = new LinkedHashMap();
    @NotNull
    private static final Map<File, FloatControl> gains = new LinkedHashMap();
    private static final int MaxGain = -16;
    private static final int MinGain = -36;
    private static float volume = class_310.method_1551().field_1690.method_1630(class_3419.field_15253) * class_310.method_1551().field_1690.method_1630(class_3419.field_15250);
    private static boolean paused;

    private RawSoundEngine() {
    }

    @JvmStatic
    public static final boolean start(@NotNull File file, @NotNull InputStream stream) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        if (volume <= 0.0f) {
            return false;
        }
        if (file.exists()) {
            AudioInputStream audioIn = AudioSystem.getAudioInputStream(stream);
            Clip clip = AudioSystem.getClip();
            clip.open(audioIn);
            Intrinsics.checkNotNullExpressionValue((Object)clip, (String)"clip");
            loadedSounds.put(file, clip);
            Map<File, FloatControl> map = gains;
            Control control = clip.getControl(FloatControl.Type.MASTER_GAIN);
            Intrinsics.checkNotNull((Object)control, (String)"null cannot be cast to non-null type javax.sound.sampled.FloatControl");
            FloatControl floatControl = (FloatControl)control;
            map.put(file, floatControl);
            FloatControl floatControl2 = gains.get(file);
            Intrinsics.checkNotNull((Object)floatControl2);
            floatControl2.setValue(volume * (float)(MaxGain - MinGain) + (float)MinGain);
            clip.start();
            bl = true;
        } else {
            System.out.println((Object)(file + " not found"));
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean start$default(File file, InputStream inputStream, int n, Object object) {
        if ((n & 2) != 0) {
            inputStream = new FileInputStream(file);
        }
        return RawSoundEngine.start(file, inputStream);
    }

    @JvmStatic
    public static final void setVolume(float volume) {
        RawSoundEngine.volume = volume;
        for (FloatControl i : gains.values()) {
            i.setValue(volume * (float)(MaxGain - MinGain) + (float)MinGain);
        }
    }

    @JvmStatic
    public static final void stopSound(@NotNull File sound) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Clip clip = loadedSounds.get(sound);
        if (clip != null) {
            clip.close();
        }
        loadedSounds.remove(sound);
    }

    @JvmStatic
    public static final void stopSounds() {
        for (File i : loadedSounds.keySet()) {
            RawSoundEngine.stopSound(i);
        }
    }

    public final void pause() {
        for (Clip i : loadedSounds.values()) {
            if (i.isRunning()) {
                paused = true;
            }
            i.stop();
        }
    }

    public final void resume() {
        paused = false;
        for (Clip i : loadedSounds.values()) {
            i.start();
        }
    }

    public final boolean isAnythingPlaying() {
        for (Clip i : loadedSounds.values()) {
            if (!i.isRunning()) continue;
            return true;
        }
        return paused;
    }
}

