/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.peripheral;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public interface IWorkMonitor {
    public boolean shouldWork();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean runWork(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable should not be null");
        if (!this.canWork()) {
            return false;
        }
        long start = System.nanoTime();
        try {
            runnable.run();
        }
        finally {
            this.trackWork(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        return true;
    }

    public boolean canWork();

    public void trackWork(long var1, @Nonnull TimeUnit var3);
}

