/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle.event;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.event.TurtleAction;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.shared.util.BlockPos;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.world.World;

public abstract class TurtleInventoryEvent
extends TurtleBlockEvent {
    private final Container handler;

    protected TurtleInventoryEvent(@Nonnull ITurtleAccess turtle, @Nonnull TurtleAction action, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Container handler) {
        super(turtle, action, world, pos);
        this.handler = handler;
    }

    @Nullable
    public Container getItemHandler() {
        return this.handler;
    }

    public static class Drop
    extends TurtleInventoryEvent {
        private final ItemStack stack;

        public Drop(@Nonnull ITurtleAccess turtle, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Container handler, @Nonnull ItemStack stack) {
            super(turtle, TurtleAction.DROP, world, pos, handler);
            Objects.requireNonNull(stack, "stack cannot be null");
            this.stack = stack;
        }

        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }
    }

    public static class Suck
    extends TurtleInventoryEvent {
        public Suck(@Nonnull ITurtleAccess turtle, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Container handler) {
            super(turtle, TurtleAction.SUCK, world, pos, handler);
        }
    }
}

