/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Palette;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;

public final class FixedWidthFontRenderer {
    public static final int FONT_HEIGHT = 9;
    public static final int FONT_WIDTH = 6;
    public static final float WIDTH = 256.0f;
    public static final float BACKGROUND_START = 0.9765625f;
    public static final float BACKGROUND_END = 0.984375f;

    public static void drawString(float x, float y, float z, @Nonnull TextBuffer text, @Nonnull TextBuffer textColour, @Nullable TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.bindFont();
        FixedWidthFontRenderer.drawString2(x, y, z, text, textColour, backgroundColour, palette, greyscale, leftMarginSize, rightMarginSize);
    }

    private static void bindFont() {
        Minecraft.getMinecraft().textureManager.loadTexture("/assets/computercraft/textures/gui/term_font.png").bind();
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
    }

    private static void drawString2(float x, float y, float z, @Nonnull TextBuffer text, @Nonnull TextBuffer textColour, @Nullable TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize) {
        if (backgroundColour != null) {
            FixedWidthFontRenderer.drawBackground(x, y, backgroundColour, palette, greyscale, leftMarginSize, rightMarginSize, 9.0f);
        }
        for (int i = 0; i < text.length(); ++i) {
            float r;
            float g2;
            float b;
            double[] colour = palette.getColour(FixedWidthFontRenderer.getColour(textColour.charAt(i), Colour.BLACK));
            if (greyscale) {
                g2 = b = FixedWidthFontRenderer.toGreyscale(colour);
                r = b;
            } else {
                r = (float)colour[0];
                g2 = (float)colour[1];
                b = (float)colour[2];
            }
            int index = text.charAt(i);
            if (index > 255) {
                index = 63;
            }
            FixedWidthFontRenderer.drawChar(x + (float)(i * 6), y, z, index, r, g2, b);
        }
    }

    private static void drawBackground(float x, float y, @Nonnull TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize, float height) {
        if (leftMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(Tessellator.instance, x - leftMarginSize, y, leftMarginSize, height, palette, greyscale, backgroundColour.charAt(0));
        }
        if (rightMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(Tessellator.instance, x + (float)(backgroundColour.length() * 6), y, rightMarginSize, height, palette, greyscale, backgroundColour.charAt(backgroundColour.length() - 1));
        }
        int blockStart = 0;
        char blockColour = '\u0000';
        for (int i = 0; i < backgroundColour.length(); ++i) {
            char colourIndex = backgroundColour.charAt(i);
            if (colourIndex == blockColour) continue;
            if (blockColour != '\u0000') {
                FixedWidthFontRenderer.drawQuad(Tessellator.instance, x + (float)(blockStart * 6), y, (float)(6 * (i - blockStart)), height, palette, greyscale, blockColour);
            }
            blockColour = colourIndex;
            blockStart = i;
        }
        if (blockColour != '\u0000') {
            FixedWidthFontRenderer.drawQuad(Tessellator.instance, x + (float)(blockStart * 6), y, (float)(6 * (backgroundColour.length() - blockStart)), height, palette, greyscale, blockColour);
        }
    }

    public static int getColour(char c, Colour def) {
        return 15 - Terminal.getColour(c, def);
    }

    public static float toGreyscale(double[] rgb) {
        return (float)((rgb[0] + rgb[1] + rgb[2]) / 3.0);
    }

    private static void drawChar(float x, float y, float z, int index, float r, float g2, float b) {
        if (index == 0 || index == 32) {
            return;
        }
        int column = index % 16;
        int row = index / 16;
        int xStart = 1 + column * 8;
        int yStart = 1 + row * 11;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(4);
        tessellator.setColorRGBA_F(r, g2, b, 1.0f);
        tessellator.addVertexWithUV((double)x, (double)y, (double)z, (double)((float)xStart / 256.0f), (double)((float)yStart / 256.0f));
        tessellator.addVertexWithUV((double)x, (double)(y + 9.0f), (double)z, (double)((float)xStart / 256.0f), (double)((float)(yStart + 9) / 256.0f));
        tessellator.addVertexWithUV((double)(x + 6.0f), (double)y, (double)z, (double)((float)(xStart + 6) / 256.0f), (double)((float)yStart / 256.0f));
        tessellator.draw();
        tessellator.startDrawing(4);
        tessellator.setColorRGBA_F(r, g2, b, 1.0f);
        tessellator.addVertexWithUV((double)(x + 6.0f), (double)y, (double)z, (double)((float)(xStart + 6) / 256.0f), (double)((float)yStart / 256.0f));
        tessellator.addVertexWithUV((double)x, (double)(y + 9.0f), (double)z, (double)((float)xStart / 256.0f), (double)((float)(yStart + 9) / 256.0f));
        tessellator.addVertexWithUV((double)(x + 6.0f), (double)(y + 9.0f), (double)z, (double)((float)(xStart + 6) / 256.0f), (double)((float)(yStart + 9) / 256.0f));
        tessellator.draw();
    }

    private static void drawQuad(Tessellator tessellator, float x, float y, float width, float height, Palette palette, boolean greyscale, char colourIndex) {
        float r;
        float g2;
        float b;
        double[] colour = palette.getColour(FixedWidthFontRenderer.getColour(colourIndex, Colour.BLACK));
        if (greyscale) {
            g2 = b = FixedWidthFontRenderer.toGreyscale(colour);
            r = b;
        } else {
            r = (float)colour[0];
            g2 = (float)colour[1];
            b = (float)colour[2];
        }
        FixedWidthFontRenderer.drawQuad(tessellator, x, y, width, height, r, g2, b);
    }

    private static void drawQuad(Tessellator tessellator, float x, float y, float width, float height, float r, float g2, float b) {
        tessellator.startDrawing(4);
        tessellator.setColorRGBA_F(r, g2, b, 1.0f);
        tessellator.addVertexWithUV((double)x, (double)y, 0.0, 0.9765625, 0.9765625);
        tessellator.addVertexWithUV((double)x, (double)(y + height), 0.0, 0.9765625, 0.984375);
        tessellator.addVertexWithUV((double)(x + width), (double)y, 0.0, 0.984375, 0.9765625);
        tessellator.draw();
        tessellator.startDrawing(4);
        tessellator.setColorRGBA_F(r, g2, b, 1.0f);
        tessellator.addVertexWithUV((double)(x + width), (double)y, 0.0, 0.984375, 0.9765625);
        tessellator.addVertexWithUV((double)x, (double)(y + height), 0.0, 0.9765625, 0.984375);
        tessellator.addVertexWithUV((double)(x + width), (double)(y + height), 0.0, 0.984375, 0.984375);
        tessellator.draw();
    }

    public static void drawTerminalWithoutCursor(float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.bindFont();
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        FixedWidthFontRenderer.drawBackground(x, y - topMarginSize, terminal.getBackgroundColourLine(0), palette, greyscale, leftMarginSize, rightMarginSize, topMarginSize);
        FixedWidthFontRenderer.drawBackground(x, y + (float)(height * 9), terminal.getBackgroundColourLine(height - 1), palette, greyscale, leftMarginSize, rightMarginSize, bottomMarginSize);
        for (int i = 0; i < height; ++i) {
            FixedWidthFontRenderer.drawString2(x, y + (float)(9 * i), 0.0f, terminal.getLine(i), terminal.getTextColourLine(i), terminal.getBackgroundColourLine(i), palette, greyscale, leftMarginSize, rightMarginSize);
        }
    }

    public static void drawCursor(float x, float y, @Nonnull Terminal terminal, boolean greyscale) {
        FixedWidthFontRenderer.bindFont();
        Palette palette = terminal.getPalette();
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int cursorX = terminal.getCursorX();
        int cursorY = terminal.getCursorY();
        if (terminal.getCursorBlink() && cursorX >= 0 && cursorX < width && cursorY >= 0 && cursorY < height && FrameInfo.getGlobalCursorBlink()) {
            float r;
            float g2;
            float b;
            double[] colour = palette.getColour(15 - terminal.getTextColour());
            if (greyscale) {
                g2 = b = FixedWidthFontRenderer.toGreyscale(colour);
                r = b;
            } else {
                r = (float)colour[0];
                g2 = (float)colour[1];
                b = (float)colour[2];
            }
            FixedWidthFontRenderer.drawChar(x + (float)(cursorX * 6), y + (float)(cursorY * 9), 0.0f, 95, r, g2, b);
        }
    }

    public static void drawTerminal(float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.bindFont();
        FixedWidthFontRenderer.drawTerminalWithoutCursor(x, y, terminal, greyscale, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize);
        FixedWidthFontRenderer.drawCursor(x, y, terminal, greyscale);
    }

    public static void drawEmptyTerminal(float x, float y, float width, float height) {
        FixedWidthFontRenderer.drawEmptyTerminal(Tessellator.instance, x, y, width, height);
    }

    public static void drawEmptyTerminal(Tessellator tessellator, float x, float y, float width, float height) {
        FixedWidthFontRenderer.bindFont();
        Colour colour = Colour.BLACK;
        FixedWidthFontRenderer.drawQuad(tessellator, x, y, width, height, colour.getR(), colour.getG(), colour.getB());
    }

    public static void drawBlocker(Tessellator tessellator, float x, float y, float width, float height) {
        FixedWidthFontRenderer.bindFont();
        Colour colour = Colour.BLACK;
        FixedWidthFontRenderer.drawQuad(tessellator, x, y, width, height, colour.getR(), colour.getG(), colour.getB());
    }
}

