/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui.widgets;

import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.IComputer;
import java.util.BitSet;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiElement;
import org.lwjgl.input.Keyboard;

public class WidgetTerminal
extends Gui
implements GuiElement {
    private static final float TERMINATE_TIME = 0.5f;
    private final Minecraft client;
    private final Supplier<ClientComputer> computer;
    private final int termWidth;
    private final int termHeight;
    private final int leftMargin;
    private final int rightMargin;
    private final int topMargin;
    private final int bottomMargin;
    private final BitSet keysDown = new BitSet(256);
    private float terminateTimer = -1.0f;
    private float rebootTimer = -1.0f;
    private float shutdownTimer = -1.0f;
    private int lastMouseButton = -1;
    private int lastMouseX = -1;
    private int lastMouseY = -1;

    public WidgetTerminal(Minecraft client, Supplier<ClientComputer> computer, int termWidth, int termHeight, int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
        this.client = client;
        this.computer = computer;
        this.termWidth = termWidth;
        this.termHeight = termHeight;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
    }

    public int getX() {
        return 0;
    }

    public void setX(int i) {
    }

    public int getY() {
        return 0;
    }

    public void setY(int i) {
    }

    public int getWidth() {
        return this.termWidth * 6;
    }

    public void setWidth(int i) {
    }

    public int getHeight() {
        return this.termHeight * 9;
    }

    public void setHeight(int i) {
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        ClientComputer computer = this.computer.get();
        if (computer == null || !computer.isColour() || button < 0 || button > 2) {
            return;
        }
        Terminal term = computer.getTerminal();
        if (term != null) {
            int charX = (int)(mouseX / 6.0);
            int charY = (int)(mouseY / 9.0);
            charX = Math.min(Math.max(charX, 0), term.getWidth() - 1);
            charY = Math.min(Math.max(charY, 0), term.getHeight() - 1);
            computer.mouseClick(button + 1, charX + 1, charY + 1);
            this.lastMouseButton = button;
            this.lastMouseX = charX;
            this.lastMouseY = charY;
        }
    }

    public void mouseReleased(double mouseX, double mouseY, int button) {
        ClientComputer computer = this.computer.get();
        if (computer == null || !computer.isColour() || button < 0 || button > 2) {
            return;
        }
        Terminal term = computer.getTerminal();
        if (term != null) {
            int charX = (int)(mouseX / 6.0);
            int charY = (int)(mouseY / 9.0);
            charX = Math.min(Math.max(charX, 0), term.getWidth() - 1);
            charY = Math.min(Math.max(charY, 0), term.getHeight() - 1);
            if (this.lastMouseButton == button) {
                computer.mouseUp(this.lastMouseButton + 1, charX + 1, charY + 1);
                this.lastMouseButton = -1;
            }
            this.lastMouseX = charX;
            this.lastMouseY = charY;
        }
    }

    public void mouseDragged(double mouseX, double mouseY, int button) {
        ClientComputer computer = this.computer.get();
        if (computer == null || !computer.isColour() || button < 0 || button > 2) {
            return;
        }
        Terminal term = computer.getTerminal();
        if (term != null) {
            int charX = (int)(mouseX / 6.0);
            int charY = (int)(mouseY / 9.0);
            charX = Math.min(Math.max(charX, 0), term.getWidth() - 1);
            charY = Math.min(Math.max(charY, 0), term.getHeight() - 1);
            if (button == this.lastMouseButton && (charX != this.lastMouseX || charY != this.lastMouseY)) {
                computer.mouseDrag(button + 1, charX + 1, charY + 1);
                this.lastMouseX = charX;
                this.lastMouseY = charY;
            }
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        ClientComputer computer = this.computer.get();
        if (computer == null || !computer.isColour() || delta == 0.0) {
            return false;
        }
        Terminal term = computer.getTerminal();
        if (term != null) {
            int charX = (int)(mouseX / 6.0);
            int charY = (int)(mouseY / 9.0);
            charX = Math.min(Math.max(charX, 0), term.getWidth() - 1);
            charY = Math.min(Math.max(charY, 0), term.getHeight() - 1);
            computer.mouseScroll(delta < 0.0 ? 1 : -1, charX + 1, charY + 1);
            this.lastMouseX = charX;
            this.lastMouseY = charY;
        }
        return true;
    }

    public void keyPressed(int key, int scancode, int modifiers) {
        if (key == Keyboard.KEY_ESCAPE) {
            return;
        }
        if ((modifiers & 2) != 0) {
            switch (key) {
                case 84: {
                    if (this.terminateTimer < 0.0f) {
                        this.terminateTimer = 0.0f;
                    }
                    return;
                }
                case 83: {
                    if (this.shutdownTimer < 0.0f) {
                        this.shutdownTimer = 0.0f;
                    }
                    return;
                }
                case 82: {
                    if (this.rebootTimer < 0.0f) {
                        this.rebootTimer = 0.0f;
                    }
                    return;
                }
                case 86: {
                    String clipboard = this.client.readFromClipboard();
                    if (clipboard == null) break;
                    int newLineIndex1 = clipboard.indexOf("\r");
                    int newLineIndex2 = clipboard.indexOf("\n");
                    if (newLineIndex1 >= 0 && newLineIndex2 >= 0) {
                        clipboard = clipboard.substring(0, Math.min(newLineIndex1, newLineIndex2));
                    } else if (newLineIndex1 >= 0) {
                        clipboard = clipboard.substring(0, newLineIndex1);
                    } else if (newLineIndex2 >= 0) {
                        clipboard = clipboard.substring(0, newLineIndex2);
                    }
                    if (!clipboard.isEmpty()) {
                        if (clipboard.length() > 512) {
                            clipboard = clipboard.substring(0, 512);
                        }
                        this.queueEvent("paste", clipboard);
                    }
                    return;
                }
            }
        }
        if (key >= 0 && this.terminateTimer < 0.0f && this.rebootTimer < 0.0f && this.shutdownTimer < 0.0f) {
            boolean repeat = this.keysDown.get(key);
            this.keysDown.set(key);
            IComputer computer = this.computer.get();
            if (computer != null) {
                computer.keyDown(key, repeat);
            }
        }
    }

    public void keyReleased(int key, int scancode, int modifiers) {
        if (key >= 0 && this.keysDown.get(key)) {
            this.keysDown.set(key, false);
            IComputer computer = this.computer.get();
            if (computer != null) {
                computer.keyUp(key);
            }
        }
        switch (key) {
            case 84: {
                this.terminateTimer = -1.0f;
                break;
            }
            case 82: {
                this.rebootTimer = -1.0f;
                break;
            }
            case 83: {
                this.shutdownTimer = -1.0f;
                break;
            }
            case 341: 
            case 345: {
                this.shutdownTimer = -1.0f;
                this.rebootTimer = -1.0f;
                this.terminateTimer = -1.0f;
            }
        }
    }

    public void charTyped(char ch) {
        if (ch >= ' ' && ch <= '~' || ch >= '\u00a0' && ch <= '\u00ff') {
            this.queueEvent("char", Character.toString(ch));
        }
    }

    private void queueEvent(String event, Object ... args) {
        ClientComputer computer = this.computer.get();
        if (computer != null) {
            computer.queueEvent(event, args);
        }
    }

    public void update() {
        ClientComputer computer;
        if (this.terminateTimer >= 0.0f && this.terminateTimer < 0.5f) {
            float f;
            this.terminateTimer += 0.05f;
            if (f > 0.5f) {
                this.queueEvent("terminate");
            }
        }
        if (this.shutdownTimer >= 0.0f && this.shutdownTimer < 0.5f) {
            float f;
            this.shutdownTimer += 0.05f;
            if (f > 0.5f && (computer = this.computer.get()) != null) {
                computer.shutdown();
            }
        }
        if (this.rebootTimer >= 0.0f && this.rebootTimer < 0.5f) {
            float f;
            this.rebootTimer += 0.05f;
            if (f > 0.5f && (computer = this.computer.get()) != null) {
                computer.reboot();
            }
        }
    }

    private void queueEvent(String event) {
        ClientComputer computer = this.computer.get();
        if (computer != null) {
            computer.queueEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(int originX, int originY) {
        Supplier<ClientComputer> supplier = this.computer;
        synchronized (supplier) {
            Terminal terminal;
            ClientComputer computer = this.computer.get();
            Terminal terminal2 = terminal = computer != null ? computer.getTerminal() : null;
            if (terminal != null) {
                FixedWidthFontRenderer.drawTerminal(originX, originY, terminal, !computer.isColour(), this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin);
            } else {
                FixedWidthFontRenderer.drawEmptyTerminal(originX - this.leftMargin, originY - this.rightMargin, this.termWidth * 6 + this.leftMargin + this.rightMargin, this.termHeight * 9 + this.topMargin + this.bottomMargin);
            }
        }
    }
}

