/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Palette;
import net.minecraft.client.render.tessellator.Tessellator;

public final class PrintoutRenderer {
    public static final int X_SIZE = 172;
    public static final int Y_SIZE = 209;
    public static final int X_TEXT_MARGIN = 13;
    public static final int Y_TEXT_MARGIN = 11;
    public static final int COVER_SIZE = 12;
    private static final float BG_SIZE = 256.0f;
    private static final int X_FOLD_SIZE = 12;
    private static final int COVER_Y = 209;
    private static final int COVER_X = 220;

    private PrintoutRenderer() {
    }

    public static void drawText(int x, int y, float z, int start, TextBuffer[] text, TextBuffer[] colours) {
        for (int line = 0; line < 21 && line < text.length; ++line) {
            FixedWidthFontRenderer.drawString(x, y + line * 9, z, text[start + line], colours[start + line], null, Palette.DEFAULT, false, 0.0f, 0.0f);
        }
    }

    public static void drawBorder(float x, float y, float z, int page, int pages, boolean isBook) {
        int n;
        int leftPages = page;
        int rightPages = pages - page - 1;
        if (isBook) {
            float offset = PrintoutRenderer.offsetAt(pages);
            float left = x - 4.0f - offset;
            float right = x + 172.0f + offset - 4.0f;
            PrintoutRenderer.drawTexture(left - 4.0f, y - 8.0f, z, 220.0f, 0.0f, 12.0f, 233.0f);
            PrintoutRenderer.drawTexture(right, y - 8.0f, z, 232.0f, 0.0f, 12.0f, 233.0f);
            PrintoutRenderer.drawTexture(x - offset, y, z, 172.0f + offset * 2.0f, 209.0f, 226.0f, 12.0f, 12.0f, 209.0f);
            float borderX = left;
            while (borderX < right) {
                double thisWidth = Math.min(right - borderX, 172.0f);
                PrintoutRenderer.drawTexture(borderX, y - 8.0f, z, 0.0f, 209.0f, (float)thisWidth, 12.0f);
                PrintoutRenderer.drawTexture(borderX, y + 209.0f - 4.0f, z, 0.0f, 221.0f, (float)thisWidth, 12.0f);
                borderX = (float)((double)borderX + thisWidth);
            }
        }
        PrintoutRenderer.drawTexture(x, y, z + 0.02f, 24.0f, 0.0f, 86.0f, 209.0f);
        for (n = 0; n <= leftPages; ++n) {
            PrintoutRenderer.drawTexture(x - PrintoutRenderer.offsetAt(n), y, z - 0.001f * (float)n + 0.02f, n == leftPages ? 0.0f : 12.0f, 0.0f, 12.0f, 209.0f);
        }
        PrintoutRenderer.drawTexture(x + 86.0f, y, z + 0.02f, 110.0f, 0.0f, 86.0f, 209.0f);
        for (n = 0; n <= rightPages; ++n) {
            PrintoutRenderer.drawTexture(x + 160.0f + PrintoutRenderer.offsetAt(n), y, z - 0.001f * (float)n + 0.02f, 196 + (n == rightPages ? 12 : 0), 0.0f, 12.0f, 209.0f);
        }
    }

    public static float offsetAt(int page) {
        return (float)(32.0 * (1.0 - Math.pow(1.2, -page)));
    }

    private static void drawTexture(float x, float y, float z, float u, float v, float width, float height) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)x, (double)(y + height), (double)z, (double)(u / 256.0f), (double)((v + height) / 256.0f));
        tessellator.addVertexWithUV((double)(x + width), (double)(y + height), (double)z, (double)((u + width) / 256.0f), (double)((v + height) / 256.0f));
        tessellator.addVertexWithUV((double)(x + width), (double)y, (double)z, (double)((u + width) / 256.0f), (double)(v / 256.0f));
        tessellator.addVertexWithUV((double)x, (double)y, (double)z, (double)(u / 256.0f), (double)(v / 256.0f));
        tessellator.draw();
    }

    private static void drawTexture(float x, float y, float z, float width, float height, float u, float v, float tWidth, float tHeight) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)x, (double)(y + height), (double)z, (double)(u / 256.0f), (double)((v + tHeight) / 256.0f));
        tessellator.addVertexWithUV((double)(x + width), (double)(y + height), (double)z, (double)((u + tWidth) / 256.0f), (double)((v + tHeight) / 256.0f));
        tessellator.addVertexWithUV((double)(x + width), (double)y, (double)z, (double)((u + tWidth) / 256.0f), (double)(v / 256.0f));
        tessellator.addVertexWithUV((double)x, (double)y, (double)z, (double)(u / 256.0f), (double)(v / 256.0f));
        tessellator.draw();
    }
}

