/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IWorkMonitor;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class ComputerAccess
implements IComputerAccess {
    private final IAPIEnvironment environment;
    private final Set<String> mounts = new HashSet<String>();

    protected ComputerAccess(IAPIEnvironment environment) {
        this.environment = environment;
    }

    public void unmountAll() {
        FileSystem fileSystem = this.environment.getFileSystem();
        for (String mount : this.mounts) {
            fileSystem.unmount(mount);
        }
        this.mounts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String mount(@Nonnull String desiredLoc, @Nonnull IMount mount, @Nonnull String driveName) {
        String location;
        Objects.requireNonNull(desiredLoc, "desiredLocation cannot be null");
        Objects.requireNonNull(mount, "mount cannot be null");
        Objects.requireNonNull(driveName, "driveName cannot be null");
        FileSystem fileSystem = this.environment.getFileSystem();
        if (fileSystem == null) {
            throw new IllegalStateException("File system has not been created");
        }
        FileSystem fileSystem2 = fileSystem;
        synchronized (fileSystem2) {
            location = this.findFreeLocation(desiredLoc);
            if (location != null) {
                try {
                    fileSystem.mount(driveName, location, mount);
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
            }
        }
        if (location != null) {
            this.mounts.add(location);
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String mountWritable(@Nonnull String desiredLoc, @Nonnull IWritableMount mount, @Nonnull String driveName) {
        String location;
        Objects.requireNonNull(desiredLoc, "desiredLocation cannot be null");
        Objects.requireNonNull(mount, "mount cannot be null");
        Objects.requireNonNull(driveName, "driveName cannot be null");
        FileSystem fileSystem = this.environment.getFileSystem();
        if (fileSystem == null) {
            throw new IllegalStateException("File system has not been created");
        }
        FileSystem fileSystem2 = fileSystem;
        synchronized (fileSystem2) {
            location = this.findFreeLocation(desiredLoc);
            if (location != null) {
                try {
                    fileSystem.mountWritable(driveName, location, mount);
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
            }
        }
        if (location != null) {
            this.mounts.add(location);
        }
        return location;
    }

    @Override
    public void unmount(String location) {
        if (location == null) {
            return;
        }
        if (!this.mounts.contains(location)) {
            throw new IllegalStateException("You didn't mount this location");
        }
        this.environment.getFileSystem().unmount(location);
        this.mounts.remove(location);
    }

    @Override
    public int getID() {
        return this.environment.getComputerID();
    }

    @Override
    public void queueEvent(@Nonnull String event, Object ... arguments) {
        Objects.requireNonNull(event, "event cannot be null");
        this.environment.queueEvent(event, arguments);
    }

    @Override
    @Nonnull
    public IWorkMonitor getMainThreadMonitor() {
        return this.environment.getMainThreadMonitor();
    }

    private String findFreeLocation(String desiredLoc) {
        try {
            FileSystem fileSystem = this.environment.getFileSystem();
            if (!fileSystem.exists(desiredLoc)) {
                return desiredLoc;
            }
            return null;
        }
        catch (FileSystemException e) {
            return null;
        }
    }
}

