/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.handles.BinaryReadableHandle;
import dan200.computercraft.core.apis.handles.BinaryWritableHandle;
import dan200.computercraft.core.apis.handles.EncodedReadableHandle;
import dan200.computercraft.core.apis.handles.EncodedWritableHandle;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.filesystem.FileSystemWrapper;
import dan200.computercraft.core.tracking.TrackingField;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Function;

public class FSAPI
implements ILuaAPI {
    private final IAPIEnvironment environment;
    private FileSystem fileSystem = null;

    public FSAPI(IAPIEnvironment env) {
        this.environment = env;
    }

    private static long getFileTime(FileTime time) {
        return time == null ? 0L : time.toMillis();
    }

    @Override
    public String[] getNames() {
        return new String[]{"fs"};
    }

    @Override
    public void startup() {
        this.fileSystem = this.environment.getFileSystem();
    }

    @Override
    public void shutdown() {
        this.fileSystem = null;
    }

    @LuaFunction
    public final String[] list(String path) throws LuaException {
        this.environment.addTrackingChange(TrackingField.FS_OPS);
        try {
            return this.fileSystem.list(path);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final String combine(IArguments arguments) throws LuaException {
        StringBuilder result = new StringBuilder();
        result.append(FileSystem.sanitizePath(arguments.getString(0), true));
        int n = arguments.count();
        for (int i = 1; i < n; ++i) {
            String part = FileSystem.sanitizePath(arguments.getString(i), true);
            if (result.length() != 0 && !part.isEmpty()) {
                result.append('/');
            }
            result.append(part);
        }
        return FileSystem.sanitizePath(result.toString(), true);
    }

    @LuaFunction
    public final String getName(String path) {
        return FileSystem.getName(path);
    }

    @LuaFunction
    public final String getDir(String path) {
        return FileSystem.getDirectory(path);
    }

    @LuaFunction
    public final long getSize(String path) throws LuaException {
        try {
            return this.fileSystem.getSize(path);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final boolean exists(String path) {
        try {
            return this.fileSystem.exists(path);
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @LuaFunction
    public final boolean isDir(String path) {
        try {
            return this.fileSystem.isDir(path);
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @LuaFunction
    public final boolean isReadOnly(String path) {
        try {
            return this.fileSystem.isReadOnly(path);
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @LuaFunction
    public final void makeDir(String path) throws LuaException {
        try {
            this.environment.addTrackingChange(TrackingField.FS_OPS);
            this.fileSystem.makeDir(path);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final void move(String path, String dest) throws LuaException {
        try {
            this.environment.addTrackingChange(TrackingField.FS_OPS);
            this.fileSystem.move(path, dest);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final void copy(String path, String dest) throws LuaException {
        try {
            this.environment.addTrackingChange(TrackingField.FS_OPS);
            this.fileSystem.copy(path, dest);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final void delete(String path) throws LuaException {
        try {
            this.environment.addTrackingChange(TrackingField.FS_OPS);
            this.fileSystem.delete(path);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final Object[] open(String path, String mode) throws LuaException {
        this.environment.addTrackingChange(TrackingField.FS_OPS);
        try {
            switch (mode) {
                case "r": {
                    FileSystemWrapper<BufferedReader> reader = this.fileSystem.openForRead(path, EncodedReadableHandle::openUtf8);
                    return new Object[]{new EncodedReadableHandle(reader.get(), reader)};
                }
                case "w": {
                    FileSystemWrapper<BufferedWriter> writer = this.fileSystem.openForWrite(path, false, EncodedWritableHandle::openUtf8);
                    return new Object[]{new EncodedWritableHandle(writer.get(), writer)};
                }
                case "a": {
                    FileSystemWrapper<BufferedWriter> writer = this.fileSystem.openForWrite(path, true, EncodedWritableHandle::openUtf8);
                    return new Object[]{new EncodedWritableHandle(writer.get(), writer)};
                }
                case "rb": {
                    FileSystemWrapper reader = this.fileSystem.openForRead(path, Function.identity());
                    return new Object[]{BinaryReadableHandle.of((ReadableByteChannel)reader.get(), reader)};
                }
                case "wb": {
                    FileSystemWrapper writer = this.fileSystem.openForWrite(path, false, Function.identity());
                    return new Object[]{BinaryWritableHandle.of((WritableByteChannel)writer.get(), writer)};
                }
                case "ab": {
                    FileSystemWrapper writer = this.fileSystem.openForWrite(path, true, Function.identity());
                    return new Object[]{BinaryWritableHandle.of((WritableByteChannel)writer.get(), writer)};
                }
            }
            throw new LuaException("Unsupported mode");
        }
        catch (FileSystemException e) {
            return new Object[]{null, e.getMessage()};
        }
    }

    @LuaFunction
    public final Object[] getDrive(String path) throws LuaException {
        try {
            Object[] objectArray;
            if (this.fileSystem.exists(path)) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.fileSystem.getMountLabel(path);
            } else {
                objectArray = null;
            }
            return objectArray;
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final Object getFreeSpace(String path) throws LuaException {
        try {
            long freeSpace = this.fileSystem.getFreeSpace(path);
            return freeSpace >= 0L ? Long.valueOf(freeSpace) : "unlimited";
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final String[] find(String path) throws LuaException {
        try {
            this.environment.addTrackingChange(TrackingField.FS_OPS);
            return this.fileSystem.find(path);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final Object getCapacity(String path) throws LuaException {
        try {
            OptionalLong capacity = this.fileSystem.getCapacity(path);
            return capacity.isPresent() ? Long.valueOf(capacity.getAsLong()) : null;
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final Map<String, Object> attributes(String path) throws LuaException {
        try {
            BasicFileAttributes attributes = this.fileSystem.getAttributes(path);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("modification", FSAPI.getFileTime(attributes.lastModifiedTime()));
            result.put("modified", FSAPI.getFileTime(attributes.lastModifiedTime()));
            result.put("created", FSAPI.getFileTime(attributes.creationTime()));
            result.put("size", attributes.isDirectory() ? 0L : attributes.size());
            result.put("isDir", attributes.isDirectory());
            result.put("isReadOnly", this.fileSystem.isReadOnly(path));
            return result;
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }
}

