/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.LuaDateTime;
import dan200.computercraft.shared.util.StringUtil;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class OSAPI
implements ILuaAPI {
    private final IAPIEnvironment apiEnvironment;
    private final HashMap<Integer, Alarm> alarms = new HashMap();
    private int clock;
    private double time;
    private int day;
    private int nextAlarmToken = 0;

    public OSAPI(IAPIEnvironment environment) {
        this.apiEnvironment = environment;
    }

    private static float getTimeForCalendar(Calendar c) {
        float time = c.get(11);
        time += (float)c.get(12) / 60.0f;
        return time += (float)c.get(13) / 3600.0f;
    }

    private static int getDayForCalendar(Calendar c) {
        GregorianCalendar g2 = c instanceof GregorianCalendar ? (GregorianCalendar)c : new GregorianCalendar();
        int year = c.get(1);
        int day = 0;
        for (int y = 1970; y < year; ++y) {
            day += g2.isLeapYear(y) ? 366 : 365;
        }
        return day += c.get(6);
    }

    private static long getEpochForCalendar(Calendar c) {
        return c.getTime().getTime();
    }

    @Override
    public String[] getNames() {
        return new String[]{"os"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        this.time = this.apiEnvironment.getComputerEnvironment().getTimeOfDay();
        this.day = this.apiEnvironment.getComputerEnvironment().getDay();
        this.clock = 0;
        HashMap<Integer, Alarm> hashMap = this.alarms;
        synchronized (hashMap) {
            this.alarms.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        ++this.clock;
        HashMap<Integer, Alarm> hashMap = this.alarms;
        synchronized (hashMap) {
            double previousTime = this.time;
            int previousDay = this.day;
            double time = this.apiEnvironment.getComputerEnvironment().getTimeOfDay();
            int day = this.apiEnvironment.getComputerEnvironment().getDay();
            if (time > previousTime || day > previousDay) {
                double now = (double)this.day * 24.0 + this.time;
                Iterator<Map.Entry<Integer, Alarm>> it = this.alarms.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, Alarm> entry = it.next();
                    Alarm alarm = entry.getValue();
                    double t2 = (double)alarm.day * 24.0 + alarm.time;
                    if (!(now >= t2)) continue;
                    this.apiEnvironment.queueEvent("alarm", entry.getKey());
                    it.remove();
                }
            }
            this.time = time;
            this.day = day;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        HashMap<Integer, Alarm> hashMap = this.alarms;
        synchronized (hashMap) {
            this.alarms.clear();
        }
    }

    @LuaFunction
    public final void queueEvent(String name, IArguments args) {
        this.apiEnvironment.queueEvent(name, args.drop(1).getAll());
    }

    @LuaFunction
    public final int startTimer(double timer) throws LuaException {
        return this.apiEnvironment.startTimer(Math.round(LuaValues.checkFinite(0, timer) / 0.05));
    }

    @LuaFunction
    public final void cancelTimer(int token) {
        this.apiEnvironment.cancelTimer(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final int setAlarm(double time) throws LuaException {
        LuaValues.checkFinite(0, time);
        if (time < 0.0 || time >= 24.0) {
            throw new LuaException("Number out of range");
        }
        HashMap<Integer, Alarm> hashMap = this.alarms;
        synchronized (hashMap) {
            int day = time > this.time ? this.day : this.day + 1;
            this.alarms.put(this.nextAlarmToken, new Alarm(time, day));
            return this.nextAlarmToken++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final void cancelAlarm(int token) {
        HashMap<Integer, Alarm> hashMap = this.alarms;
        synchronized (hashMap) {
            this.alarms.remove(token);
        }
    }

    @LuaFunction(value={"shutdown"})
    public final void doShutdown() {
        this.apiEnvironment.shutdown();
    }

    @LuaFunction(value={"reboot"})
    public final void doReboot() {
        this.apiEnvironment.reboot();
    }

    @LuaFunction(value={"getComputerID", "computerID"})
    public final int getComputerID() {
        return this.apiEnvironment.getComputerID();
    }

    @LuaFunction(value={"getComputerLabel", "computerLabel"})
    public final Object[] getComputerLabel() {
        Object[] objectArray;
        String label = this.apiEnvironment.getLabel();
        if (label == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = label;
        }
        return objectArray;
    }

    @LuaFunction
    public final void setComputerLabel(Optional<String> label) {
        this.apiEnvironment.setLabel(StringUtil.normaliseLabel(label.orElse(null)));
    }

    @LuaFunction
    public final double clock() {
        return (double)this.clock * 0.05;
    }

    @LuaFunction
    public final Object time(IArguments args) throws LuaException {
        Object value = args.get(0);
        if (value instanceof Map) {
            return LuaDateTime.fromTable((Map)value);
        }
        String param = args.optString(0, "ingame");
        switch (param.toLowerCase(Locale.ROOT)) {
            case "utc": {
                return Float.valueOf(OSAPI.getTimeForCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC"))));
            }
            case "local": {
                return Float.valueOf(OSAPI.getTimeForCalendar(Calendar.getInstance()));
            }
            case "ingame": {
                return this.time;
            }
        }
        throw new LuaException("Unsupported operation");
    }

    @LuaFunction
    public final int day(Optional<String> args) throws LuaException {
        switch (args.orElse("ingame").toLowerCase(Locale.ROOT)) {
            case "utc": {
                return OSAPI.getDayForCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            }
            case "local": {
                return OSAPI.getDayForCalendar(Calendar.getInstance());
            }
            case "ingame": {
                return this.day;
            }
        }
        throw new LuaException("Unsupported operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final long epoch(Optional<String> args) throws LuaException {
        switch (args.orElse("ingame").toLowerCase(Locale.ROOT)) {
            case "utc": {
                Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                return OSAPI.getEpochForCalendar(c);
            }
            case "local": {
                Calendar c = Calendar.getInstance();
                return OSAPI.getEpochForCalendar(c);
            }
            case "ingame": {
                HashMap<Integer, Alarm> hashMap = this.alarms;
                synchronized (hashMap) {
                    return (long)this.day * 86400000L + (long)(this.time * 3600000.0);
                }
            }
        }
        throw new LuaException("Unsupported operation");
    }

    @LuaFunction
    public final Object date(Optional<String> formatA, Optional<Long> timeA) throws LuaException {
        ZonedDateTime date;
        ZoneOffset offset;
        String format = formatA.orElse("%c");
        long time = timeA.orElseGet(() -> Instant.now().getEpochSecond());
        Instant instant = Instant.ofEpochSecond(time);
        if (format.startsWith("!")) {
            offset = ZoneOffset.UTC;
            date = ZonedDateTime.ofInstant(instant, offset);
            format = format.substring(1);
        } else {
            ZoneId id = ZoneId.systemDefault();
            offset = id.getRules().getOffset(instant);
            date = ZonedDateTime.ofInstant(instant, id);
        }
        if (format.equals("*t")) {
            return LuaDateTime.toTable(date, offset, instant);
        }
        DateTimeFormatterBuilder formatter = new DateTimeFormatterBuilder();
        LuaDateTime.format(formatter, format, offset);
        return formatter.toFormatter(Locale.ROOT).format(date);
    }

    private static class Alarm
    implements Comparable<Alarm> {
        final double time;
        final int day;

        Alarm(double time, int day) {
            this.time = time;
            this.day = day;
        }

        @Override
        public int compareTo(@Nonnull Alarm o) {
            double t2 = (double)this.day * 24.0 + this.time;
            double ot = (double)this.day * 24.0 + this.time;
            return Double.compare(t2, ot);
        }
    }
}

