/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import com.google.common.base.Objects;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.IWorkMonitor;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.ComputerExecutor;
import dan200.computercraft.core.computer.Environment;
import dan200.computercraft.core.computer.IComputerEnvironment;
import dan200.computercraft.core.computer.MainThreadExecutor;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.terminal.Terminal;
import java.util.concurrent.atomic.AtomicBoolean;

public class Computer {
    private static final int START_DELAY = 50;
    private final IComputerEnvironment environment;
    private final Terminal terminal;
    private final ComputerExecutor executor;
    private final MainThreadExecutor serverExecutor;
    private final Environment internalEnvironment = new Environment(this);
    private final AtomicBoolean externalOutputChanged = new AtomicBoolean();
    private int id;
    private String label = null;
    private boolean blinking = false;
    private boolean startRequested;
    private int ticksSinceStart = -1;

    public Computer(IComputerEnvironment environment, Terminal terminal, int id) {
        this.id = id;
        this.environment = environment;
        this.terminal = terminal;
        this.executor = new ComputerExecutor(this);
        this.serverExecutor = new MainThreadExecutor(this);
    }

    IComputerEnvironment getComputerEnvironment() {
        return this.environment;
    }

    FileSystem getFileSystem() {
        return this.executor.getFileSystem();
    }

    Terminal getTerminal() {
        return this.terminal;
    }

    public Environment getEnvironment() {
        return this.internalEnvironment;
    }

    public IAPIEnvironment getAPIEnvironment() {
        return this.internalEnvironment;
    }

    public boolean isOn() {
        return this.executor.isOn();
    }

    public void turnOn() {
        this.startRequested = true;
    }

    public void shutdown() {
        this.executor.queueStop(false, false);
    }

    public void reboot() {
        this.executor.queueStop(true, false);
    }

    public void unload() {
        this.executor.queueStop(false, true);
    }

    public void queueEvent(String event, Object[] args) {
        this.executor.queueEvent(event, args);
    }

    public boolean queueMainThread(Runnable runnable) {
        return this.serverExecutor.enqueue(runnable);
    }

    public IWorkMonitor getMainThreadMonitor() {
        return this.serverExecutor;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int assignID() {
        if (this.id < 0) {
            this.id = this.environment.assignNewID();
        }
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (!Objects.equal(label, this.label)) {
            this.label = label;
            this.externalOutputChanged.set(true);
        }
    }

    public void tick() {
        boolean blinking;
        if (this.ticksSinceStart >= 0 && this.ticksSinceStart <= 50) {
            ++this.ticksSinceStart;
        }
        if (this.startRequested && (this.ticksSinceStart < 0 || this.ticksSinceStart > 50)) {
            this.startRequested = false;
            if (!this.executor.isOn()) {
                this.ticksSinceStart = 0;
                this.executor.queueStart();
            }
        }
        this.executor.tick();
        this.internalEnvironment.tick();
        if (this.internalEnvironment.updateOutput()) {
            this.externalOutputChanged.set(true);
        }
        boolean bl = blinking = this.terminal.getCursorBlink() && this.terminal.getCursorX() >= 0 && this.terminal.getCursorX() < this.terminal.getWidth() && this.terminal.getCursorY() >= 0 && this.terminal.getCursorY() < this.terminal.getHeight();
        if (blinking != this.blinking) {
            this.blinking = blinking;
            this.externalOutputChanged.set(true);
        }
    }

    void markChanged() {
        this.externalOutputChanged.set(true);
    }

    public boolean pollAndResetChanged() {
        return this.externalOutputChanged.getAndSet(false);
    }

    public boolean isBlinking() {
        return this.isOn() && this.blinking;
    }

    public void addApi(ILuaAPI api) {
        this.executor.addApi(api);
    }
}

