/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.tracking;

import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.tracking.TrackingField;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.annotation.Nullable;

public class ComputerTracker {
    private final WeakReference<Computer> computer;
    private final int computerId;
    private final HashMap<TrackingField, Long> fields;
    private long tasks;
    private long totalTime;
    private long maxTime;
    private long serverCount;
    private long serverTime;

    public ComputerTracker(Computer computer) {
        this.computer = new WeakReference<Computer>(computer);
        this.computerId = computer.getID();
        this.fields = new HashMap();
    }

    ComputerTracker(ComputerTracker timings) {
        this.computer = timings.computer;
        this.computerId = timings.computerId;
        this.tasks = timings.tasks;
        this.totalTime = timings.totalTime;
        this.maxTime = timings.maxTime;
        this.serverCount = timings.serverCount;
        this.serverTime = timings.serverTime;
        this.fields = new HashMap<TrackingField, Long>(timings.fields);
    }

    @Nullable
    public Computer getComputer() {
        return (Computer)this.computer.get();
    }

    public int getComputerId() {
        return this.computerId;
    }

    public long getTasks() {
        return this.tasks;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getAverage() {
        return this.totalTime / this.tasks;
    }

    void addTaskTiming(long time) {
        ++this.tasks;
        this.totalTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
    }

    void addMainTiming(long time) {
        ++this.serverCount;
        this.serverTime += time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addValue(TrackingField field, long change) {
        HashMap<TrackingField, Long> hashMap = this.fields;
        synchronized (hashMap) {
            this.fields.put(field, change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(TrackingField field) {
        if (field == TrackingField.TASKS) {
            return this.tasks;
        }
        if (field == TrackingField.MAX_TIME) {
            return this.maxTime;
        }
        if (field == TrackingField.TOTAL_TIME) {
            return this.totalTime;
        }
        if (field == TrackingField.AVERAGE_TIME) {
            return this.tasks == 0L ? 0L : this.totalTime / this.tasks;
        }
        if (field == TrackingField.SERVER_COUNT) {
            return this.serverCount;
        }
        if (field == TrackingField.SERVER_TIME) {
            return this.serverTime;
        }
        HashMap<TrackingField, Long> hashMap = this.fields;
        synchronized (hashMap) {
            return this.fields.get(field);
        }
    }

    public String getFormatted(TrackingField field) {
        return field.format(this.get(field));
    }
}

