/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.fabric;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;

public class GLFWKeyboardManager {
    private static GLFWKeyboardManager instance;
    private final Map<UUID, GLFWKeyCallbackI> keyObservers = new HashMap<UUID, GLFWKeyCallbackI>();
    private final Map<UUID, GLFWCharCallbackI> charObservers = new HashMap<UUID, GLFWCharCallbackI>();

    private GLFWKeyboardManager() {
    }

    public static synchronized GLFWKeyboardManager getInstance() {
        if (instance == null) {
            instance = new GLFWKeyboardManager();
        }
        return instance;
    }

    public UUID addKeyObserver(GLFWKeyCallbackI observer) {
        UUID id = UUID.randomUUID();
        this.keyObservers.put(id, observer);
        return id;
    }

    public void removeKeyObserver(UUID id) {
        this.keyObservers.remove(id);
    }

    public void notifyKeyObservers(long window, int key, int scancode, int action, int mods) {
        this.keyObservers.values().forEach(observer -> observer.invoke(window, key, scancode, action, mods));
    }

    public UUID addCharObserver(GLFWCharCallbackI observer) {
        UUID id = UUID.randomUUID();
        this.charObservers.put(id, observer);
        return id;
    }

    public void removeCharObserver(UUID id) {
        this.charObservers.remove(id);
    }

    public void notifyCharObservers(long window, int codepoint) {
        this.charObservers.values().forEach(observer -> observer.invoke(window, codepoint));
    }
}

