/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.fabric;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.world.World;

public class Helper {
    public static boolean isServerEnvironment() {
        return Global.isServer;
    }

    public static boolean isSinglePlayer() {
        if (Global.isServer) {
            return false;
        }
        return !Minecraft.getMinecraft().isMultiplayerWorld();
    }

    public static boolean isClientWorld() {
        return !Helper.isSinglePlayer() && !Helper.isServerEnvironment();
    }

    @Nullable
    public static BlockLogic getBlockLogic(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (block == null) {
            return null;
        }
        return block.getLogic();
    }

    @Nullable
    public static <T> T getBlockLogic(World world, int x, int y, int z, Class<T> logicClass) {
        Block block = world.getBlock(x, y, z);
        if (block == null) {
            return null;
        }
        BlockLogic logic = block.getLogic();
        if (logicClass.isAssignableFrom(logic.getClass())) {
            return logicClass.cast(logic);
        }
        return null;
    }
}

