/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.fabric.mixin;

import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWKeyboardImplementation;
import dan200.computercraft.fabric.GLFWKeyboardManager;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.opengl.Display;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GLFWKeyboardImplementation.class}, remap=false)
public class GLFWKeyboardImplementationMixin {
    @Shadow
    private final byte[] key_down_buffer = new byte[349];
    @Shadow
    private GLFWKeyCallback keyCallback;
    @Shadow
    private GLFWCharCallback charCallback;
    @Shadow
    private long windowHandle;

    @Shadow
    private void putKeyboardEvent(int keycode, byte state, int ch, long nanos, boolean repeat) {
    }

    @Inject(method={"createKeyboard()V"}, at={@At(value="TAIL")})
    private void addDirectAccess(CallbackInfo info) {
        this.keyCallback = GLFWKeyCallback.create((window, glfwKey, scancode, action, mods) -> {
            int key = GLFWKeyboardImplementation.translateKeyFromGLFW((int)glfwKey);
            if (action == 1) {
                this.key_down_buffer[key] = 1;
            } else if (action == 0) {
                this.key_down_buffer[key] = 0;
            }
            this.putKeyboardEvent(key, this.key_down_buffer[key], 0, System.nanoTime(), action == 2);
            GLFWKeyboardManager.getInstance().notifyKeyObservers(window, glfwKey, scancode, action, mods);
        });
        this.charCallback = GLFWCharCallback.create((window, codepoint) -> {
            this.putKeyboardEvent(-1, (byte)1, codepoint, System.nanoTime(), false);
            GLFWKeyboardManager.getInstance().notifyCharObservers(window, codepoint);
        });
        this.windowHandle = Display.getHandle();
        GLFW.glfwSetKeyCallback((long)this.windowHandle, (GLFWKeyCallbackI)this.keyCallback);
        GLFW.glfwSetCharCallback((long)this.windowHandle, (GLFWCharCallbackI)this.charCallback);
    }
}

