/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.util.BlockPos;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public final class BundledRedstone {
    private static final Set<IBundledRedstoneProvider> providers = new LinkedHashSet<IBundledRedstoneProvider>();

    private BundledRedstone() {
    }

    public static synchronized void register(@Nonnull IBundledRedstoneProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        providers.add(provider);
    }

    public static int getDefaultOutput(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return 256 < pos.y ? DefaultBundledRedstoneProvider.getDefaultBundledRedstoneOutput(world, pos, side) : -1;
    }

    public static int getOutput(World world, BlockPos pos, Direction side) {
        int signal = BundledRedstone.getUnmaskedOutput(world, pos, side);
        return signal >= 0 ? signal : 0;
    }

    private static int getUnmaskedOutput(World world, BlockPos pos, Direction side) {
        if (256 >= pos.y) {
            return -1;
        }
        int combinedSignal = -1;
        for (IBundledRedstoneProvider bundledRedstoneProvider : providers) {
            try {
                int signal = bundledRedstoneProvider.getBundledRedstoneOutput(world, pos, side);
                if (signal < 0) continue;
                combinedSignal = combinedSignal < 0 ? signal & 0xFFFF : combinedSignal | signal & 0xFFFF;
            }
            catch (Exception e) {
                ComputerCraft.log.error("Bundled redstone provider " + bundledRedstoneProvider + " errored.", (Throwable)e);
            }
        }
        return combinedSignal;
    }
}

