/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.IMediaProvider;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.item.ItemStack;

public final class MediaProviders {
    private static final Set<IMediaProvider> providers = new LinkedHashSet<IMediaProvider>();

    private MediaProviders() {
    }

    public static synchronized void register(@Nonnull IMediaProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        providers.add(provider);
    }

    public static IMedia get(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (IMediaProvider mediaProvider : providers) {
            try {
                IMedia media = mediaProvider.getMedia(stack);
                if (media == null) continue;
                return media;
            }
            catch (Exception e) {
                ComputerCraft.log.error("Media provider " + mediaProvider + " errored.", (Throwable)e);
            }
        }
        return null;
    }
}

