/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.google.common.eventbus.Subscribe;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.event.TurtleActionEvent;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.util.BlockPos;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;

public final class TurtlePermissions {
    public static boolean isBlockEditable(World world, BlockPos pos) {
        return TurtlePermissions.isBlockEnterable(world, pos);
    }

    public static boolean isBlockEnterable(World world, BlockPos pos) {
        if (!Helper.isServerEnvironment()) {
            return true;
        }
        MinecraftServer mcServer = MinecraftServer.getInstance();
        if (mcServer.spawnProtectionRange > 0) {
            int dz;
            int dx = (int)MathHelper.abs((float)(pos.x - world.getLevelData().getSpawnX()));
            return Math.max(dx, dz = (int)MathHelper.abs((float)(pos.z - world.getLevelData().getSpawnZ()))) > mcServer.spawnProtectionRange;
        }
        return true;
    }

    @Subscribe
    public void onTurtleAction(TurtleActionEvent event) {
        if (ComputerCraft.turtleDisabledActions.contains((Object)event.getAction())) {
            event.setCanceled(true, "Action has been disabled");
        }
    }
}

