/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.shared.computer.core.ComputerState;
import net.minecraft.client.render.block.model.BlockModelHorizontalRotation;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.world.WorldSource;

public class BlockModelComputer<T extends BlockLogic>
extends BlockModelHorizontalRotation<T> {
    public BlockModelComputer(Block<T> block) {
        super(block);
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int currentMetadata = blockAccess.getBlockMetadata(x, y, z);
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(currentMetadata & 7, 5) + side.getId()];
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        if (index == Side.NORTH.getId()) {
            IconCoordinate originalFront = this.blockTextures.get(Side.NORTH);
            ComputerState currentState = ((ComputerState[])ComputerState.class.getEnumConstants())[currentMetadata >> 3 & 3];
            switch (currentState) {
                case ON: {
                    return TextureRegistry.getTexture((String)(originalFront.namespaceId.namespace() + ":block/" + originalFront.namespaceId.value() + "_on"));
                }
                case BLINKING: {
                    return TextureRegistry.getTexture((String)(originalFront.namespaceId.namespace() + ":block/" + originalFront.namespaceId.value() + "_blink"));
                }
            }
            return originalFront;
        }
        return this.blockTextures.get(Side.getSideById((int)index));
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int currentMetadata) {
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(currentMetadata & 7, 5) + side.getId()];
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        if (index == Side.NORTH.getId()) {
            IconCoordinate originalFront = this.blockTextures.get(Side.NORTH);
            ComputerState currentState = ((ComputerState[])ComputerState.class.getEnumConstants())[currentMetadata >> 3 & 3];
            switch (currentState) {
                case ON: {
                    return TextureRegistry.getTexture((String)(originalFront.namespaceId.namespace() + ":block/" + originalFront.namespaceId.value() + "_on"));
                }
                case BLINKING: {
                    return TextureRegistry.getTexture((String)(originalFront.namespaceId.namespace() + ":block/" + originalFront.namespaceId.value() + "_blink"));
                }
            }
            return originalFront;
        }
        return this.blockTextures.get(Side.getSideById((int)index));
    }
}

