/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.blocks.BlockLogicComputer;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.util.BlockPos;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public class TileEntityComputer
extends TileComputerBase {
    private ComputerProxy proxy;

    public TileEntityComputer() {
        super(ComputerFamily.NORMAL);
    }

    public TileEntityComputer(ComputerFamily family) {
        super(family);
    }

    public boolean canBeCarried(World world, Entity potentialHolder) {
        return false;
    }

    public boolean isUsableByPlayer(Player player) {
        return this.isUsable(player, false);
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
        int currentMetadata = this.getBlockMeta();
        ComputerState currentState = ((ComputerState[])ComputerState.class.getEnumConstants())[currentMetadata >> 3 & 3];
        if (currentState != newState) {
            int newMetadata = currentMetadata & 0xFFFFFFE7 | newState.ordinal() << 3;
            if (this.worldObj != null) {
                this.worldObj.setBlockMetadataWithNotify(this.x, this.y, this.z, newMetadata);
            }
        }
    }

    @Override
    public Direction getDirection() {
        return BlockLogicComputer.getDirectionFromMeta((int)this.getBlockMeta());
    }

    @Override
    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        if (localSide == ComputerSide.RIGHT) {
            return ComputerSide.LEFT;
        }
        if (localSide == ComputerSide.LEFT) {
            return ComputerSide.RIGHT;
        }
        return localSide;
    }

    @Override
    protected ServerComputer createComputer(int instanceID, int id) {
        ComputerFamily family = this.getFamily();
        ServerComputer computer = new ServerComputer(this.worldObj, id, this.label, instanceID, family, ComputerCraft.computerTermWidth, ComputerCraft.computerTermHeight);
        computer.setPosition(new BlockPos(this.x, this.y, this.z));
        return computer;
    }

    @Override
    public ComputerProxy createProxy() {
        if (this.proxy == null) {
            this.proxy = new ComputerProxy(() -> this){

                @Override
                protected TileComputerBase getTile() {
                    return TileEntityComputer.this;
                }
            };
        }
        return this.proxy;
    }
}

