/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.shared.common.ClientTerminal;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.RequestComputerMessage;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ClientComputer
extends ClientTerminal
implements IComputer {
    private final int instanceID;
    private boolean on = false;
    private boolean blinking = false;
    private CompoundTag userData = null;

    public ClientComputer(int instanceID) {
        super(false);
        this.instanceID = instanceID;
    }

    public CompoundTag getUserData() {
        return this.userData;
    }

    public void requestState() {
        NetworkHandler.sendToServer((NetworkMessage)new RequestComputerMessage(this.getInstanceID()));
    }

    @Override
    public int getInstanceID() {
        return this.instanceID;
    }

    @Override
    public void turnOn() {
        NetworkHandler.sendToServer((NetworkMessage)new ComputerActionServerMessage(this.instanceID, ComputerActionServerMessage.Action.TURN_ON));
    }

    @Override
    public void shutdown() {
        NetworkHandler.sendToServer((NetworkMessage)new ComputerActionServerMessage(this.instanceID, ComputerActionServerMessage.Action.SHUTDOWN));
    }

    @Override
    public void reboot() {
        NetworkHandler.sendToServer((NetworkMessage)new ComputerActionServerMessage(this.instanceID, ComputerActionServerMessage.Action.REBOOT));
    }

    @Override
    public void queueEvent(String event) {
        this.queueEvent(event, null);
    }

    @Override
    public void queueEvent(String event, Object[] arguments) {
        NetworkHandler.sendToServer((NetworkMessage)new QueueEventServerMessage(this.instanceID, event, arguments));
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public boolean isCursorDisplayed() {
        return this.on && this.blinking;
    }

    @Override
    public void keyDown(int key, boolean repeat) {
        NetworkHandler.sendToServer((NetworkMessage)new KeyEventServerMessage(this.instanceID, repeat ? 1 : 0, key));
    }

    @Override
    public void keyUp(int key) {
        NetworkHandler.sendToServer((NetworkMessage)new KeyEventServerMessage(this.instanceID, 2, key));
    }

    @Override
    public void mouseClick(int button, int x, int y) {
        NetworkHandler.sendToServer((NetworkMessage)new MouseEventServerMessage(this.instanceID, 0, button, x, y));
    }

    @Override
    public void mouseUp(int button, int x, int y) {
        NetworkHandler.sendToServer((NetworkMessage)new MouseEventServerMessage(this.instanceID, 2, button, x, y));
    }

    @Override
    public void mouseDrag(int button, int x, int y) {
        NetworkHandler.sendToServer((NetworkMessage)new MouseEventServerMessage(this.instanceID, 1, button, x, y));
    }

    @Override
    public void mouseScroll(int direction, int x, int y) {
        NetworkHandler.sendToServer((NetworkMessage)new MouseEventServerMessage(this.instanceID, 3, direction, x, y));
    }

    public void setState(ComputerState state, CompoundTag userData) {
        this.on = state != ComputerState.OFF;
        this.blinking = state == ComputerState.BLINKING;
        this.userData = userData;
    }
}

