/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class InputState
implements InputHandler {
    private final IContainerComputer owner;
    private final Set<Integer> keysDown = new HashSet<Integer>(4);
    private int lastMouseX;
    private int lastMouseY;
    private int lastMouseDown = -1;

    public InputState(IContainerComputer owner) {
        this.owner = owner;
    }

    @Override
    public void queueEvent(String event, Object[] arguments) {
        IComputer computer = this.owner.getComputer();
        if (computer != null) {
            computer.queueEvent(event, arguments);
        }
    }

    @Override
    public void keyDown(int key, boolean repeat) {
        this.keysDown.add(key);
        IComputer computer = this.owner.getComputer();
        if (computer != null) {
            computer.keyDown(key, repeat);
        }
    }

    @Override
    public void keyUp(int key) {
        this.keysDown.remove(key);
        IComputer computer = this.owner.getComputer();
        if (computer != null) {
            computer.keyUp(key);
        }
    }

    @Override
    public void mouseClick(int button, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        this.lastMouseDown = button;
        IComputer computer = this.owner.getComputer();
        if (computer != null) {
            computer.mouseClick(button, x, y);
        }
    }

    @Override
    public void mouseUp(int button, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        this.lastMouseDown = -1;
        IComputer computer = this.owner.getComputer();
        if (computer != null) {
            computer.mouseUp(button, x, y);
        }
    }

    @Override
    public void mouseDrag(int button, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        this.lastMouseDown = button;
        IComputer computer = this.owner.getComputer();
        if (computer != null) {
            computer.mouseDrag(button, x, y);
        }
    }

    @Override
    public void mouseScroll(int direction, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        IComputer computer = this.owner.getComputer();
        if (computer != null) {
            computer.mouseScroll(direction, x, y);
        }
    }

    public void close() {
        IComputer computer = this.owner.getComputer();
        if (computer != null) {
            Iterator<Integer> keys = this.keysDown.iterator();
            while (keys.hasNext()) {
                computer.keyUp(keys.next());
            }
            if (this.lastMouseDown != -1) {
                computer.mouseUp(this.lastMouseDown, this.lastMouseX, this.lastMouseY);
            }
        }
        this.keysDown.clear();
        this.lastMouseDown = -1;
    }
}

