/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.ComputerCraftAPIImpl;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.computer.IComputerEnvironment;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.fabric.IComputerPlayer;
import dan200.computercraft.shared.common.ServerTerminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.network.client.ComputerDataClientMessage;
import dan200.computercraft.shared.network.client.ComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.OpenGuiComputerClientMessage;
import dan200.computercraft.shared.network.client.OpenGuiTurtleClientMessage;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.util.BlockPos;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ServerComputer
extends ServerTerminal
implements IComputer,
IComputerEnvironment {
    private final int instanceID;
    private final ComputerFamily family;
    private final Computer computer;
    private World world;
    private BlockPos position;
    private CompoundTag userData;
    private boolean changed;
    private boolean changedLastFrame;
    private int ticksSincePing;
    private boolean pauseExecution;

    public ServerComputer(World world, int computerID, String label, int instanceID, ComputerFamily family, int terminalWidth, int terminalHeight) {
        super(family != ComputerFamily.NORMAL, terminalWidth, terminalHeight);
        this.instanceID = instanceID;
        this.world = world;
        this.position = null;
        this.family = family;
        this.computer = new Computer(this, this.getTerminal(), computerID);
        this.computer.setLabel(label);
        this.userData = null;
        this.changed = false;
        this.changedLastFrame = false;
        this.ticksSincePing = 0;
        this.pauseExecution = false;
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setPosition(BlockPos pos) {
        this.position = pos;
    }

    public IAPIEnvironment getAPIEnvironment() {
        return this.computer.getAPIEnvironment();
    }

    public Computer getComputer() {
        return this.computer;
    }

    @Override
    public void update() {
        if (this.pauseExecution) {
            return;
        }
        super.update();
        if (this.world == null) {
            return;
        }
        TileEntity tileEntity = this.world.getTileEntity(this.position.x, this.position.y, this.position.z);
        if (tileEntity instanceof TileTurtle) {
            this.selectedSlot = ((TileTurtle)tileEntity).getAccess().getSelectedSlot();
        }
        this.computer.tick();
        this.changedLastFrame = this.computer.pollAndResetChanged() || this.changed;
        this.changed = false;
        ++this.ticksSincePing;
    }

    public void keepAlive() {
        this.ticksSincePing = 0;
    }

    public boolean hasTimedOut() {
        return this.ticksSincePing > 100;
    }

    public void freezeComputer() {
        this.pauseExecution = true;
    }

    public void unfreezeComputer() {
        this.pauseExecution = false;
    }

    public void unload() {
        this.computer.unload();
    }

    public CompoundTag getUserData() {
        if (this.userData == null) {
            this.userData = new CompoundTag();
        }
        return this.userData;
    }

    public void updateUserData() {
        this.changed = true;
    }

    public void broadcastState(boolean force) {
        if (this.hasOutputChanged() || force) {
            NetworkHandler.sendToAllPlayers((NetworkMessage)this.createComputerPacket());
        }
        if (this.hasTerminalChanged() || force) {
            if (!Helper.isSinglePlayer()) {
                MinecraftServer server = MinecraftServer.getInstance();
                NetworkMessage packet = null;
                for (Player player : server.playerList.playerEntities) {
                    if (!this.isInteracting(player)) continue;
                    if (packet == null) {
                        packet = this.createTerminalPacket();
                    }
                    NetworkHandler.sendToPlayer((Player)player, (NetworkMessage)packet);
                }
            } else {
                this.sendSinglePlayerBroadcastState();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void sendSinglePlayerBroadcastState() {
        PlayerLocal player = Minecraft.getMinecraft().thePlayer;
        if (this.isInteracting((Player)player)) {
            NetworkHandler.sendToPlayer((Player)player, (NetworkMessage)this.createTerminalPacket());
        }
    }

    public boolean hasOutputChanged() {
        return this.changedLastFrame;
    }

    private NetworkMessage createComputerPacket() {
        return new ComputerDataClientMessage(this);
    }

    protected boolean isInteracting(Player player) {
        return this.getContainer(player) != null;
    }

    protected NetworkMessage createTerminalPacket() {
        return new ComputerTerminalClientMessage(this.getInstanceID(), this.write());
    }

    protected NetworkMessage createOpenComputerGuiPacket() {
        TerminalState state = this.write();
        return new OpenGuiComputerClientMessage(this.getInstanceID(), this.getFamily(), state.width, state.height);
    }

    @Nullable
    public IContainerComputer getContainer(Player player) {
        if (player == null) {
            return null;
        }
        IContainerComputer computerContainer = ((IComputerPlayer)player).getCurrentContainerComputer();
        return computerContainer;
    }

    @Override
    public int getInstanceID() {
        return this.instanceID;
    }

    @Override
    public void turnOn() {
        this.computer.turnOn();
    }

    @Override
    public void shutdown() {
        this.computer.shutdown();
    }

    @Override
    public void reboot() {
        this.computer.reboot();
    }

    @Override
    public void queueEvent(String event) {
        this.computer.queueEvent(event, null);
    }

    @Override
    public void queueEvent(String event, Object[] arguments) {
        this.computer.queueEvent(event, arguments);
    }

    @Override
    public boolean isOn() {
        return this.computer.isOn();
    }

    @Override
    public boolean isCursorDisplayed() {
        return this.computer.isOn() && this.computer.isBlinking();
    }

    public void sendComputerState(Player player) {
        NetworkHandler.sendToPlayer((Player)player, (NetworkMessage)this.createComputerPacket());
    }

    public void sendTerminalState(Player player) {
        NetworkHandler.sendToPlayer((Player)player, (NetworkMessage)this.createTerminalPacket());
    }

    public void sendOpenComputerGui(Player player) {
        NetworkHandler.sendToPlayer((Player)player, (NetworkMessage)this.createOpenComputerGuiPacket());
    }

    public void sendOpenGuiTurtle(Player player, TileTurtle turtle) {
        TerminalState state = this.write();
        new OpenGuiTurtleClientMessage(turtle, this.getInstanceID(), this.getFamily(), state.width, state.height).sendToPlayer(player);
    }

    public void broadcastDelete() {
        if (Helper.isServerEnvironment()) {
            NetworkHandler.sendToAllPlayers((NetworkMessage)new ComputerDeletedClientMessage(this.getInstanceID()));
        }
    }

    public int getID() {
        return this.computer.getID();
    }

    public void setID(int id) {
        this.computer.setID(id);
    }

    public String getLabel() {
        return this.computer.getLabel();
    }

    public void setLabel(String label) {
        this.computer.setLabel(label);
    }

    public int getRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalRedstoneOutput(side);
    }

    public void setRedstoneInput(ComputerSide side, int level) {
        this.computer.getEnvironment().setRedstoneInput(side, level);
    }

    public int getBundledRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalBundledRedstoneOutput(side);
    }

    public void setBundledRedstoneInput(ComputerSide side, int combination) {
        this.computer.getEnvironment().setBundledRedstoneInput(side, combination);
    }

    public void addAPI(ILuaAPI api) {
        this.computer.addApi(api);
    }

    public void setPeripheral(ComputerSide side, IPeripheral peripheral) {
        this.computer.getEnvironment().setPeripheral(side, peripheral);
    }

    public IPeripheral getPeripheral(ComputerSide side) {
        return this.computer.getEnvironment().getPeripheral(side);
    }

    @Override
    public int getDay() {
        return (int)((this.world.getWorldTime() + 6000L) / 24000L) + 1;
    }

    @Override
    public double getTimeOfDay() {
        return (double)((this.world.getWorldTime() + 6000L) % 24000L) / 1000.0;
    }

    @Override
    public long getComputerSpaceLimit() {
        return ComputerCraft.computerSpaceLimit;
    }

    @Override
    @Nonnull
    public String getHostString() {
        return String.format("ComputerCraft %s (Minecraft %s)", ComputerCraftAPI.getInstalledVersion(), "1.16.4");
    }

    @Override
    @Nonnull
    public String getUserAgent() {
        return "computercraft/" + ComputerCraftAPI.getInstalledVersion();
    }

    @Override
    public int assignNewID() {
        return ComputerCraftAPI.createUniqueNumberedSaveDir(this.world, "computer");
    }

    @Override
    public IWritableMount createSaveDirMount(String subPath, long capacity) {
        return ComputerCraftAPI.createSaveDirMount(this.world, subPath, capacity);
    }

    @Override
    public IMount createResourceMount(String domain, String subPath) {
        return ComputerCraftAPI.createResourceMount(domain, subPath);
    }

    @Override
    public InputStream createResourceFile(String domain, String subPath) {
        return ComputerCraftAPIImpl.getResourceFile(domain, subPath);
    }
}

