/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.common.ComputerCraftBlocks;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import javax.annotation.Nonnull;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;

public abstract class ItemBlockComputerBase<T extends BlockLogic>
extends ItemBlock<T>
implements IComputerItem,
IMedia {
    private final ComputerFamily family;

    public ItemBlockComputerBase(Block<T> block) {
        super(block);
        if (block.equals(ComputerCraftBlocks.COMPUTER_ADVANCED)) {
            this.family = ComputerFamily.ADVANCED;
            return;
        }
        if (block.equals(ComputerCraftBlocks.TURTLE_ADVANCED)) {
            this.family = ComputerFamily.ADVANCED;
            return;
        }
        this.family = ComputerFamily.NORMAL;
    }

    public String getTranslatedDescription(ItemStack stack) {
        int id;
        I18n i18n = I18n.getInstance();
        String text = super.getTranslatedDescription(stack);
        if (this.getLabel(stack) == null && (id = this.getComputerID(stack)) >= 0) {
            text = text + "\n" + i18n.translateKeyAndFormat("gui.computercraft.tooltip.computer_id", new Object[]{id});
        }
        return text;
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return IComputerItem.super.getLabel(stack);
    }

    @Override
    public final ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        if (label != null) {
            stack.setCustomName(label);
        } else {
            stack.removeCustomName();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        int id;
        ComputerFamily family = this.getFamily();
        if (family != ComputerFamily.COMMAND && (id = this.getComputerID(stack)) >= 0) {
            return ComputerCraftAPI.createSaveDirMount(world, "computer/" + id, ComputerCraft.computerSpaceLimit);
        }
        return null;
    }
}

