/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import dan200.computercraft.fabric.mixin.ContainerCraftingAccessor;
import dan200.computercraft.shared.media.items.ItemPrintout;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.inventory.container.ContainerCrafting;

public final class PrintoutRecipe
extends RecipeEntryCrafting<RecipeSymbol[], ItemStack>
implements HasJsonAdapter {
    @Nonnull
    public ItemStack getOutput() {
        return ItemPrintout.createMultipleFromTitleAndText(null, null, null);
    }

    public boolean matches(ContainerCrafting inventory) {
        return this.getCraftingResult(inventory) != null;
    }

    public boolean matchesQuery(SearchQuery searchQuery) {
        return false;
    }

    public ItemStack getCraftingResult(ContainerCrafting inventory) {
        int numPages = 0;
        int numPrintouts = 0;
        ItemStack[] printouts = null;
        boolean stringFound = false;
        boolean leatherFound = false;
        boolean printoutFound = false;
        int width = ((ContainerCraftingAccessor)inventory).getWidth();
        int height = inventory.getContainerSize() / width;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ItemStack stack = inventory.getItem(x + y * width);
                if (stack == null) continue;
                if (stack.getItem() instanceof ItemPrintout && ((ItemPrintout)stack.getItem()).getType() != ItemPrintout.Type.BOOK) {
                    if (printouts == null) {
                        printouts = new ItemStack[9];
                    }
                    printouts[numPrintouts] = stack;
                    numPages += ItemPrintout.getPageCount(stack);
                    ++numPrintouts;
                    printoutFound = true;
                    continue;
                }
                if (stack.getItem().equals(Items.PAPER)) {
                    if (printouts == null) {
                        printouts = new ItemStack[9];
                    }
                    printouts[numPrintouts] = stack;
                    ++numPages;
                    ++numPrintouts;
                    continue;
                }
                if (stack.getItem().equals(Items.STRING) && !stringFound) {
                    stringFound = true;
                    continue;
                }
                if (stack.getItem().equals(Items.LEATHER) && !leatherFound) {
                    leatherFound = true;
                    continue;
                }
                return null;
            }
        }
        if (numPages <= 16 && stringFound && printoutFound && numPrintouts >= (leatherFound ? 1 : 2)) {
            String[] text = new String[numPages * 21];
            String[] colours = new String[numPages * 21];
            int line = 0;
            for (int printout = 0; printout < numPrintouts; ++printout) {
                ItemStack stack = printouts[printout];
                if (stack.getItem() instanceof ItemPrintout) {
                    String[] pageText = ItemPrintout.getText(printouts[printout]);
                    String[] pageColours = ItemPrintout.getColours(printouts[printout]);
                    for (int pageLine = 0; pageLine < pageText.length; ++pageLine) {
                        text[line] = pageText[pageLine];
                        colours[line] = pageColours[pageLine];
                        ++line;
                    }
                    continue;
                }
                for (int pageLine = 0; pageLine < 21; ++pageLine) {
                    text[line] = "";
                    colours[line] = "";
                    ++line;
                }
            }
            String title = null;
            if (printouts[0].getItem() instanceof ItemPrintout) {
                title = ItemPrintout.getTitle(printouts[0]);
            }
            if (leatherFound) {
                return ItemPrintout.createBookFromTitleAndText(title, text, colours);
            }
            return ItemPrintout.createMultipleFromTitleAndText(title, text, colours);
        }
        return null;
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack[] onCraftResult(ContainerCrafting containerCrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int i = 0; i < containerCrafting.getContainerSize(); ++i) {
            ItemStack itemStack = containerCrafting.getItem(i);
            if (itemStack == null) continue;
            containerCrafting.removeItem(i, 1);
            if (!itemStack.getItem().hasContainerItem()) continue;
            containerCrafting.setItem(i, new ItemStack(itemStack.getItem().getContainerItem()));
        }
        return returnStack;
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new PrintoutRecipeJsonAdapter();
    }

    private static class PrintoutRecipeJsonAdapter
    implements RecipeJsonAdapter<PrintoutRecipe> {
        private PrintoutRecipeJsonAdapter() {
        }

        public PrintoutRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new PrintoutRecipe();
        }

        public JsonElement serialize(PrintoutRecipe src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", src.toString().replaceFirst("/*$", ""));
            obj.addProperty("type", Registries.RECIPE_TYPES.getKey(((Object)((Object)src)).getClass()));
            return obj;
        }
    }
}

